#' Contour_filled ggplot
#'
#' @description Create a contour_filled ggplot with a wrapper around [ggplot2::ggplot()] + [geom_contour_filled()][ggplot2::geom_contour_filled()].
#'
#' @inheritParams gg_blanket
#'
#' @return A ggplot object.
#' @export
#'
#' @examples
#' library(ggplot2)
#' library(dplyr)
#'
#' set_blanket()
#'
#' faithfuld |>
#'   gg_contour_filled(
#'     x = waiting,
#'     y = eruptions,
#'     z = density,
#'     bins = 8,
#'   )
#'
gg_contour_filled <- function(data = NULL,
                              ...,
                              stat = "contour_filled",
                              position = "identity",
                              coord = ggplot2::coord_cartesian(clip = "off"),
                              mode = NULL,
                              x = NULL,
                              xmin = NULL,
                              xmax = NULL,
                              xend = NULL,
                              y = NULL,
                              ymin = NULL,
                              ymax = NULL,
                              yend = NULL,
                              z = NULL,
                              col = NULL,
                              facet = NULL,
                              facet2 = NULL,
                              group = NULL,
                              subgroup = NULL,
                              label = NULL,
                              text = NULL,
                              sample = NULL,
                              mapping = NULL,
                              x_breaks = NULL,
                              x_expand = NULL,
                              x_expand_limits = NULL,
                              x_labels = NULL,
                              x_limits = NULL,
                              x_oob = scales::oob_keep,
                              x_position = "bottom",
                              x_label = NULL,
                              x_transform = NULL,
                              y_breaks = NULL,
                              y_expand = NULL,
                              y_expand_limits = NULL,
                              y_labels = NULL,
                              y_limits = NULL,
                              y_oob = scales::oob_keep,
                              y_position = "left",
                              y_label = NULL,
                              y_transform = NULL,
                              col_breaks = NULL,
                              col_drop = FALSE,
                              col_expand_limits = NULL,
                              col_labels = NULL,
                              col_legend_ncol = NULL,
                              col_legend_nrow = NULL,
                              col_legend_rev = FALSE,
                              col_limits = NULL,
                              col_oob = scales::oob_keep,
                              col_palette = NULL,
                              col_palette_na = NULL,
                              col_rescale = scales::rescale(),
                              col_steps = FALSE,
                              col_label = NULL,
                              col_transform = NULL,
                              facet_axes = NULL,
                              facet_axis_labels = "margins",
                              facet_drop = FALSE,
                              facet_labels = NULL,
                              facet_layout = NULL,
                              facet_ncol = NULL,
                              facet_nrow = NULL,
                              facet_scales = "fixed",
                              facet_space = "fixed",
                              title = NULL,
                              subtitle = NULL,
                              caption = NULL,
                              label_to_case = snakecase::to_sentence_case) {
  gg_blanket(
    data = data,
    geom = "contour_filled",
    stat = stat,
    position = position,
    coord = coord,
    mode = mode,
    x = {{ x }},
    y = {{ y }},
    xmin = {{ xmin }},
    xmax = {{ xmax }},
    xend = {{ xend }},
    ymin = {{ ymin }},
    ymax = {{ ymax }},
    yend = {{ yend }},
    z = {{ z }},
    col = {{ col }},
    facet = {{ facet }},
    facet2 = {{ facet2 }},
    group = {{ group }},
    subgroup = {{ subgroup }},
    label = {{ label }},
    text = {{ text }},
    sample = {{ sample }},
    mapping = mapping,
    x_breaks = x_breaks,
    x_expand = x_expand,
    x_expand_limits = x_expand_limits,
    x_labels = x_labels,
    x_limits = x_limits,
    x_oob = x_oob,
    x_position = x_position,
    x_label = x_label,
    x_transform = x_transform,
    y_breaks = y_breaks,
    y_expand = y_expand,
    y_expand_limits = y_expand_limits,
    y_labels = y_labels,
    y_limits = y_limits,
    y_oob = y_oob,
    y_position = y_position,
    y_label = y_label,
    y_transform = y_transform,
    col_breaks = col_breaks,
    col_drop = col_drop,
    col_expand_limits = col_expand_limits,
    col_labels = col_labels,
    col_legend_ncol = col_legend_ncol,
    col_legend_nrow = col_legend_nrow,
    col_legend_rev = col_legend_rev,
    col_limits = col_limits,
    col_oob = col_oob,
    col_palette = col_palette,
    col_palette_na = col_palette_na,
    col_rescale = col_rescale,
    col_steps = col_steps,
    col_label = col_label,
    col_transform = col_transform,
    facet_axes = facet_axes,
    facet_axis_labels = facet_axis_labels,
    facet_drop = facet_drop,
    facet_labels = facet_labels,
    facet_layout = facet_layout,
    facet_ncol = facet_ncol,
    facet_nrow = facet_nrow,
    facet_scales = facet_scales,
    facet_space = facet_space,
    title = title,
    subtitle = subtitle,
    caption = caption,
    label_to_case = label_to_case,
    ...
  )
}
