% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tbl_graph.R
\name{as_tbl_graph}
\alias{as_tbl_graph}
\alias{as_tbl_graph.tidy_dagitty}
\alias{as_tbl_graph.dagitty}
\title{Convert DAGS to tidygraph}
\usage{
\method{as_tbl_graph}{tidy_dagitty}(x, directed = TRUE, ...)

\method{as_tbl_graph}{dagitty}(x, directed = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{tidy_dagitty} or \code{dagitty}}

\item{directed}{logical. Should the constructed graph be directed? Default
is \code{TRUE}}

\item{...}{other arguments passed to \code{as_tbl_graph}}
}
\value{
a \code{tbl_graph}
}
\description{
A thin wrapper to convert \code{tidy_dagitty} and \code{dagitty} objects to
\code{tbl_graph}, which can then be used to work in \code{tidygraph} and
\code{ggraph} directly. See \code{\link[tidygraph:tbl_graph]{tidygraph::as_tbl_graph()}}.
}
\examples{

library(ggraph)
library(tidygraph)
butterfly_bias() \%>\%
  as_tbl_graph() \%>\%
  ggraph() +
  geom_edge_diagonal() +
  geom_node_point()

}
