% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points.R
\name{ob_point}
\alias{ob_point}
\alias{ob_polar}
\title{ob_point}
\usage{
ob_point(
  x = 0,
  y = 0,
  alpha = numeric(0),
  color = character(0),
  fill = character(0),
  shape = numeric(0),
  size = numeric(0),
  stroke = numeric(0),
  style = S7::class_missing,
  id = character(0),
  ...
)

ob_polar(
  theta = S7::class_missing,
  r = numeric(0),
  alpha = numeric(0),
  color = character(0),
  fill = character(0),
  shape = numeric(0),
  size = numeric(0),
  stroke = numeric(0),
  style = S7::class_missing,
  id = character(0)
)
}
\arguments{
\item{x}{Vector of coordinates on the x-axis (also can take a tibble/data.frame or 2-column matrix as input.)}

\item{y}{Vector of coordinates on the y-axis}

\item{alpha}{numeric value for alpha transparency}

\item{color}{character string for color}

\item{fill}{character string for fill color}

\item{shape}{Point shape type. Can be specified with an integer (between 0 and 25), a single character (which uses that character as the plotting symbol), a . to draw the smallest rectangle that is visible (i.e., about one pixel), an NA to draw nothing, or a mapping to a discrete variable.}

\item{size}{numeric size}

\item{stroke}{Width of point border line}

\item{style}{Gets and sets the styles associated with points}

\item{id}{character string to identify object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> properties passed to \code{style}}

\item{theta}{Angle of the vector from the origin to the \code{\link{ob_point}}}

\item{r}{Radius = Distance from the origin to the ob_point}
}
\value{
ob_point object
}
\description{
Points are specified with x and y coordinates.

Polar points are ordinary points but are specified with an angle (theta) and a radial distance (r)
}
\section{Slots}{

\describe{
\item{\code{auto_label}}{Gets x and y coordinates and makes a label \code{"(x,y)"}}

\item{\code{geom}}{A function that converts the object to a geom. Any additional parameters are passed to \code{ggplot2::geom_point}.}

\item{\code{length}}{The number of points in the ob_point object}

\item{\code{tibble}}{Gets a \code{\link[tibble:tibble]{tibble::tibble}} containing parameters and styles used by \code{\link[ggplot2:geom_point]{ggplot2::geom_point}}.}

\item{\code{xy}}{Gets a 2-column matrix of the x and y coordinates of the ob_point object.}
}}

\examples{
ggdiagram() +
  ob_point(1:5, 1:5) +
  ggplot2::theme_minimal()

ggdiagram() +
  ob_polar(degree(seq(0, 330, 30)), r = 2) +
  ggplot2::theme_minimal()
}
