% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{ob_segment}
\alias{ob_segment}
\title{ob_segment class}
\usage{
ob_segment(
  p1 = S7::class_missing,
  p2 = S7::class_missing,
  label = character(0),
  label_sloped = TRUE,
  alpha = numeric(0),
  arrow_head = ggarrow::arrow_head_minimal(90),
  arrow_fins = list(),
  arrowhead_length = 7,
  length_head = numeric(0),
  length_fins = numeric(0),
  color = character(0),
  lineend = numeric(0),
  linejoin = numeric(0),
  linewidth = numeric(0),
  linewidth_fins = numeric(0),
  linewidth_head = numeric(0),
  linetype = numeric(0),
  resect = numeric(0),
  resect_fins = numeric(0),
  resect_head = numeric(0),
  stroke_color = character(0),
  stroke_width = numeric(0),
  style = S7::class_missing,
  x = S7::class_missing,
  xend = S7::class_missing,
  y = S7::class_missing,
  yend = S7::class_missing,
  id = character(0),
  ...
)
}
\arguments{
\item{p1}{starting point (\code{\link{ob_point}})}

\item{p2}{end point (\code{\link{ob_point}})}

\item{label}{A character, angle, or \code{\link{ob_label}} object}

\item{label_sloped}{A logical value indicating whether the label should be sloped with the segment}

\item{alpha}{numeric value for alpha transparency}

\item{arrow_head}{A 2-column matrix of polygon points}

\item{arrow_fins}{A 2-column matrix of polygon points}

\item{arrowhead_length}{Determines the size of the arrow ornaments. This parameter becomes the \code{length} parameter in ggarrow functions. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner.}

\item{length_head}{Determines the size of the arrow head. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner. From ggarrow.}

\item{length_fins}{Determines the size of the arrow fins. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner. From ggarrow.}

\item{color}{character string for color}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linewidth}{Width of lines}

\item{linewidth_fins}{Line width for arrow fins}

\item{linewidth_head}{Line width for arrow fins}

\item{linetype}{type of lines}

\item{resect}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow head and fins.}

\item{resect_fins}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow fins}

\item{resect_head}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow head.}

\item{stroke_color}{Color of point border line}

\item{stroke_width}{Stroke width in arrows}

\item{style}{a style list}

\item{x}{overrides the x-coordinate of p1}

\item{xend}{overrides the y-coordinate of p1}

\item{y}{overrides the x-coordinate of p2}

\item{yend}{overrides the y-coordinate of p2}

\item{id}{character string to identify object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> properties passed to style}
}
\value{
ob_segment object
}
\description{
ob_segment class
}
\section{Slots}{

\describe{
\item{\code{geom}}{A function that converts the object to a geom. Any additional parameters are passed to \code{ggarrow::geom_arrow_segment}.}

\item{\code{hatch}}{A function that puts hatch (tally) marks on segments. Often used to indicate which segments have the same length. The \code{k} parameter controls how many hatch marks to display. The \code{height} parameter controls how long the hatch mark segment is. The \code{sep} parameter controls the separation between hatch marks when \code{k > 2}. Additional parameters sent to \code{ob_segment}.}

\item{\code{midpoint}}{A function that selects 1 or more midpoints of the ob_segment. The \code{position} argument can be between 0 and 1. Additional arguments are passed to \code{ob_point}.}

\item{\code{nudge}}{A function to move the segment by x and y units.}
}}

