% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_lineribbon.R
\name{stat_lineribbon}
\alias{stat_lineribbon}
\title{Line + multiple-ribbon plot (shortcut stat)}
\usage{
stat_lineribbon(
  mapping = NULL,
  data = NULL,
  geom = "lineribbon",
  position = "identity",
  ...,
  .width = c(0.5, 0.8, 0.95),
  point_interval = "median_qi",
  orientation = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{\link[=stat_lineribbon]{stat_lineribbon()}} and \code{\link[=geom_lineribbon]{geom_lineribbon()}}}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.
Setting this equal to \code{"dodge"} (\code{\link[=position_dodge]{position_dodge()}}) or \code{"dodgejust"} (\code{\link[=position_dodgejust]{position_dodgejust()}}) can be useful if
you have overlapping geometries.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. These are often aesthetics, used to set an aesthetic
to a fixed value, like \code{colour = "red"} or \code{linewidth = 3} (see \strong{Aesthetics}, below). They may also be
parameters to the paired geom/stat. When paired with the default geom, \code{\link[=geom_lineribbon]{geom_lineribbon()}},
these include:
\describe{
\item{\code{step}}{Should the line/ribbon be drawn as a step function? One of:
\itemize{
\item \code{FALSE} (default): do not draw as a step function.
\item \code{"mid"} (or \code{TRUE}): draw steps midway between adjacent x values.
\item \code{"hv"}: draw horizontal-then-vertical steps.
\item \code{"vh"}: draw as vertical-then-horizontal steps.
}
\code{TRUE} is an alias for \code{"mid"} because for a step function with ribbons, \code{"mid"} is probably what you want
(for the other two step approaches the ribbons at either the very first or very last x value will not be
visible).}
}}

\item{.width}{The \code{.width} argument passed to \code{point_interval}: a vector of probabilities to use
that determine the widths of the resulting intervals. If multiple probabilities are provided,
multiple intervals per group are generated, each with a different probability interval (and
value of the corresponding \code{.width} and \code{level} generated variables).}

\item{point_interval}{A function from the \code{\link[=point_interval]{point_interval()}} family (e.g., \code{median_qi},
\code{mean_qi}, \code{mode_hdi}, etc), or a string giving the name of a function from that family
(e.g., \code{"median_qi"}, \code{"mean_qi"}, \code{"mode_hdi"}, etc; if a string, the caller's environment is searched
for the function, followed by the \pkg{ggdist} environment). This function determines the point summary
(typically mean, median, or mode) and interval type (quantile interval, \code{qi};
highest-density interval, \code{hdi}; or highest-density continuous interval, \code{hdci}). Output will
be converted to the appropriate \code{x}- or \code{y}-based aesthetics depending on the value of \code{orientation}.
See the \code{\link[=point_interval]{point_interval()}} family of functions for more information.}

\item{orientation}{Whether this geom is drawn horizontally or vertically. One of:
\itemize{
\item \code{NA} (default): automatically detect the orientation based on how the aesthetics
are assigned. Automatic detection works most of the time.
\item \code{"horizontal"} (or \code{"y"}): draw horizontally, using the \code{y} aesthetic to identify different
groups. For each group, uses the \code{x}, \code{xmin}, \code{xmax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
\item \code{"vertical"} (or \code{"x"}): draw vertically, using the \code{x} aesthetic to identify different
groups. For each group, uses the \code{y}, \code{ymin}, \code{ymax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
}
For compatibility with the base ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias
for \code{"vertical"} and \code{"y"} as an alias for \code{"horizontal"} (\pkg{ggdist} had an \code{orientation} parameter
before base ggplot did, hence the discrepancy).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? \code{NA},
the default, includes if any aesthetics are mapped. \code{FALSE} never includes,
and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Stat} representing a line + multiple-ribbon geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
A combination of \code{\link[=stat_slabinterval]{stat_slabinterval()}} and \code{\link[=geom_lineribbon]{geom_lineribbon()}} with sensible defaults
for making line + multiple-ribbon plots. While \code{\link[=geom_lineribbon]{geom_lineribbon()}} is intended for use on data
frames that have already been summarized using a \code{\link[=point_interval]{point_interval()}} function,
\code{\link[=stat_lineribbon]{stat_lineribbon()}} is intended for use directly on data frames of draws or of
analytical distributions, and will perform the summarization using a \code{\link[=point_interval]{point_interval()}}
function.

\strong{Roughly equivalent to:}

\preformatted{stat_slabinterval(
  aes(
    group = after_stat(level),
    fill = after_stat(level),
    order = after_stat(level),
    size = NULL
  ),
  geom = "lineribbon",
  .width = c(0.5, 0.8, 0.95),
  show_slab = FALSE,
  show.legend = NA
)}
}
\details{
\strong{To visualize sample data}, such as a data distribution, samples from a
bootstrap distribution, or a Bayesian posterior, you can supply samples to
the \code{x} or \code{y} aesthetic.

\strong{To visualize analytical distributions}, you can use the \code{xdist} or \code{ydist}
aesthetic. For historical reasons, you can also use \code{dist} to specify the distribution, though
this is not recommended as it does not work as well with orientation detection.
These aesthetics can be used as follows:
\itemize{
\item \code{xdist}, \code{ydist}, and \code{dist} can be any distribution object from the \href{https://pkg.mitchelloharawild.com/distributional/}{distributional}
package (\code{\link[=dist_normal]{dist_normal()}}, \code{\link[=dist_beta]{dist_beta()}}, etc) or can be a \code{\link[posterior:rvar]{posterior::rvar()}} object.
Since these functions are vectorized,
other columns can be passed directly to them in an \code{\link[=aes]{aes()}} specification; e.g.
\code{aes(dist = dist_normal(mu, sigma))} will work if \code{mu} and \code{sigma} are columns in the
input data frame.
\item \code{dist} can be a character vector giving the distribution name. Then the  \code{arg1}, ... \code{arg9}
aesthetics (or \code{args} as a list column) specify distribution arguments. Distribution names
should correspond to R functions that have \code{"p"}, \code{"q"}, and \code{"d"} functions; e.g. \code{"norm"}
is a valid distribution name because R defines the \code{\link[=pnorm]{pnorm()}}, \code{\link[=qnorm]{qnorm()}}, and \code{\link[=dnorm]{dnorm()}}
functions for Normal distributions.

See the \code{\link[=parse_dist]{parse_dist()}} function for a useful way to generate \code{dist} and \code{args}
values from human-readable distribution specs (like \code{"normal(0,1)"}). Such specs are also
produced by other packages (like the \code{brms::get_prior} function in brms); thus,
\code{\link[=parse_dist]{parse_dist()}} combined with the stats described here can help you visualize the output
of those functions.
}
}
\section{Computed Variables}{

The following variables are computed by this stat and made available for
use in aesthetic specifications (\code{\link[=aes]{aes()}}) using the \code{\link[=after_stat]{after_stat()}}
function or the \code{after_stat} argument of \code{\link[=stage]{stage()}}:
\itemize{
\item \code{x} or \code{y}: For slabs, the input values to the slab function.
For intervals, the point summary from the interval function. Whether it is \code{x} or \code{y} depends on \code{orientation}
\item \code{xmin} or \code{ymin}: For intervals, the lower end of the interval from the interval function.
\item \code{xmax} or \code{ymax}: For intervals, the upper end of the interval from the interval function.
\item \code{.width}: For intervals, the interval width as a numeric value in \verb{[0, 1]}.
For slabs, the width of the smallest interval containing that value of the slab.
\item \code{level}: For intervals, the interval width as an ordered factor.
For slabs, the level of the smallest interval containing that value of the slab.
\item \code{pdf}: For slabs, the probability density function (PDF).
If \code{options("ggdist.experimental.slab_data_in_intervals")} is \code{TRUE}:
For intervals, the PDF at the point summary; intervals also have \code{pdf_min} and \code{pdf_max}
for the PDF at the lower and upper ends of the interval.
\item \code{cdf}: For slabs, the cumulative distribution function.
If \code{options("ggdist.experimental.slab_data_in_intervals")} is \code{TRUE}:
For intervals, the CDF at the point summary; intervals also have \code{cdf_min} and \code{cdf_max}
for the CDF at the lower and upper ends of the interval.
}
}

\section{Aesthetics}{

The line+ribbon \code{stat}s and \code{geom}s have a wide variety of aesthetics that control
the appearance of their two sub-geometries: the \strong{line} and the \strong{ribbon}.

These \code{stat}s support the following aesthetics:

\itemize{
\item{\code{x}: x position of the geometry (when orientation = \code{"vertical"}); or sample data to be summarized
(when \code{orientation = "horizontal"} with sample data).}
\item{\code{y}: y position of the geometry (when orientation = \code{"horizontal"}); or sample data to be summarized
(when \code{orientation = "vertical"} with sample data).}
\item{\code{weight}: When using samples (i.e. the \code{x} and \code{y} aesthetics, not \code{xdist} or \code{ydist}), optional
weights to be applied to each draw.}
\item{\code{xdist}: When using analytical distributions, distribution to map on the x axis: a \pkg{distributional}
object (e.g. \code{\link[=dist_normal]{dist_normal()}}) or a \code{\link[posterior:rvar]{posterior::rvar()}} object.}
\item{\code{ydist}: When using analytical distributions, distribution to map on the y axis: a \pkg{distributional}
object (e.g. \code{\link[=dist_normal]{dist_normal()}}) or a \code{\link[posterior:rvar]{posterior::rvar()}} object.}
\item{\code{dist}: When using analytical distributions, a name of a distribution (e.g. \code{"norm"}), a
\pkg{distributional} object (e.g. \code{\link[=dist_normal]{dist_normal()}}), or a \code{\link[posterior:rvar]{posterior::rvar()}} object. See \strong{Details}.}
\item{\code{args}: Distribution arguments (\code{args} or \code{arg1}, ... \code{arg9}). See \strong{Details}.}
}

In addition, in their default configuration (paired with \code{\link[=geom_lineribbon]{geom_lineribbon()}})
the following aesthetics are supported by the underlying geom:

\strong{Ribbon-specific aesthetics}

\itemize{
\item{\code{xmin}: Left edge of the ribbon sub-geometry (if \code{orientation = "horizontal"}).}
\item{\code{xmax}: Right edge of the ribbon sub-geometry (if \code{orientation = "horizontal"}).}
\item{\code{ymin}: Lower edge of the ribbon sub-geometry (if \code{orientation = "vertical"}).}
\item{\code{ymax}: Upper edge of the ribbon sub-geometry (if \code{orientation = "vertical"}).}
\item{\code{order}: The order in which ribbons are drawn. Ribbons with the smallest mean value of \code{order}
are drawn first (i.e., will be drawn below ribbons with larger mean values of \code{order}). If
\code{order} is not supplied to \code{\link[=geom_lineribbon]{geom_lineribbon()}}, \code{-abs(xmax - xmin)} or \code{-abs(ymax - ymax)}
(depending on \code{orientation}) is used, having the effect of drawing the widest (on average)
ribbons on the bottom. \code{\link[=stat_lineribbon]{stat_lineribbon()}} uses \code{order = after_stat(level)} by default,
causing the ribbons generated from the largest \code{.width} to be drawn on the bottom.}
}

\strong{Color aesthetics}

\itemize{
\item{\code{colour}: (or \code{color}) The color of the \strong{line} sub-geometry.}
\item{\code{fill}: The fill color of the \strong{ribbon} sub-geometry.}
\item{\code{alpha}: The opacity of the \strong{line} and \strong{ribbon} sub-geometries.}
\item{\code{fill_ramp}: A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{\link[=scale_fill_ramp]{scale_fill_ramp()}} for examples.}
}

\strong{Line aesthetics}

\itemize{
\item{\code{linewidth}: Width of \strong{line}. In \pkg{ggplot2} < 3.4, was called \code{size}.}
\item{\code{linetype}: Type of \strong{line} (e.g., \code{"solid"}, \code{"dashed"}, etc)}
}

\strong{Other aesthetics} (these work as in standard \code{geom}s)

\itemize{
\item{\code{group}}
}

See examples of some of these aesthetics in action in \code{vignette("lineribbon")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the
\link[ggdist]{scales} documentation. Learn more about basic ggplot aesthetics in
\code{vignette("ggplot2-specs")}.
}

\examples{
library(dplyr)
library(ggplot2)
library(distributional)

theme_set(theme_ggdist())

# ON SAMPLE DATA
set.seed(12345)
tibble(
  x = rep(1:10, 100),
  y = rnorm(1000, x)
) \%>\%
  ggplot(aes(x = x, y = y)) +
  stat_lineribbon() +
  scale_fill_brewer()

# ON ANALYTICAL DISTRIBUTIONS
# Vectorized distribution types, like distributional::dist_normal()
# and posterior::rvar(), can be used with the `xdist` / `ydist` aesthetics
tibble(
  x = 1:10,
  sd = seq(1, 3, length.out = 10)
) \%>\%
  ggplot(aes(x = x, ydist = dist_normal(x, sd))) +
  stat_lineribbon() +
  scale_fill_brewer()
}
\seealso{
See \code{\link[=geom_lineribbon]{geom_lineribbon()}} for the geom underlying this stat.

Other lineribbon stats: 
\code{\link{stat_ribbon}()}
}
\concept{lineribbon stats}
