% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-aaaaa.R, R/scale-days.R, R/scale-hours.R,
%   R/scale-seconds.R
\name{time_scales}
\alias{time_scales}
\alias{scale_x_days}
\alias{scale_y_days}
\alias{scale_x_hours}
\alias{scale_y_hours}
\alias{scale_x_seconds}
\alias{scale_y_seconds}
\title{Scales for durations}
\usage{
scale_x_days(name = "Time", breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), oob = scales::censor, na.value = NA_real_,
  position = "bottom", time_wrap = NULL, unit = "day", log = FALSE)

scale_y_days(name = "Time", breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), oob = scales::censor, na.value = NA_real_,
  position = "left", time_wrap = NULL, unit = "day", log = FALSE)

scale_x_hours(name = "Time", breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), oob = scales::censor, na.value = NA_real_,
  position = "bottom", time_wrap = NULL, unit = "h", log = FALSE)

scale_y_hours(name = "Time", breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), oob = scales::censor, na.value = NA_real_,
  position = "left", time_wrap = NULL, unit = "h", log = FALSE)

scale_x_seconds(name = "Time", breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), oob = scales::censor, na.value = NA_real_,
  position = "bottom", time_wrap = NULL, unit = "s", log = FALSE)

scale_y_seconds(name = "Time", breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), oob = scales::censor, na.value = NA_real_,
  position = "left", time_wrap = NULL, unit = "s", log = FALSE)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the breaks specified by \code{date_breaks}
\item A \code{Date}/\code{POSIXct} vector giving positions of breaks
\item A function that takes the limits as input and returns breaks as output
}}

\item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the breaks specified by \code{date_minor_breaks}
\item A \code{Date}/\code{POSIXct} vector giving positions of minor breaks
\item A function that takes the limits as input and returns minor breaks as
output
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits
}}

\item{expand}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance
away from the axes. Use the convenience function \code{ggplot2::expand_scale()}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{oob}{Function that handles limits outside of the scale limits
(out of bounds). The default replaces out of bounds values with \code{NA}.}

\item{na.value}{Missing values will be replaced with this value.}

\item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}

\item{time_wrap}{duration (in seconds) used to wrap the labels of the time axis}

\item{unit}{the name of unit (string) to be used in the label (e.g. one could use \code{"second"} instead of \code{"s"})}

\item{log}{logical, whether axis should be on a log-transformed}
}
\value{
A ggplot scale.
}
\description{
A set of scales used to represent experimental durations.
}
\details{
\code{time_wrap} is useful, for instance, to express time within a day (ZT), instead of absolute time.
}
\examples{
# We generate some data
metadata <- data.frame(id = sprintf("toy_experiment | \%02d", 1:20),
                   condition = c("A","B"))
dt <- toy_activity_data(metadata, 3)
# Then, a simple plot
pl <-  ggetho(dt, aes(y = asleep)) + stat_pop_etho()
pl + scale_x_hours(breaks = days(c(1, 2)))
pl + scale_x_hours()
pl + scale_x_days(breaks = days(c(1, 2)))
pl + scale_x_days()

# To express time modulus `time_wrap`
# e.g. time n the day
pl + scale_x_hours(time_wrap = hours(24)) +
     coord_cartesian(xlim=c(0, days(2)))

# On a shorter time scale
pl <-  ggetho(dt[t < hours(5)], aes(z = asleep)) + stat_tile_etho()
pl + scale_x_hours()
pl + scale_x_hours(breaks = hours(1:4))
pl + scale_x_seconds(breaks = hours(1:4))
}
\references{
\itemize{
\item The relevant \href{https://rethomics.github.io/ggetho.html#coordinate-and-scales}{rethomic tutorial section}
}
}
\seealso{
\itemize{
\item \link{ggetho} to generate a plot object
\item \link[ggplot2:scale_x_continuous]{ggplot2::scale_x_continuous}, the defaut ggplot scale, to understand limits, breaks, labels and name
}
}
