% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle.R
\name{geom_circle}
\alias{geom_circle}
\alias{stat_circle}
\title{Circles based on center and radius}
\usage{
stat_circle(
  mapping = NULL,
  data = NULL,
  geom = "circle",
  position = "identity",
  n = 360,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_circle(
  mapping = NULL,
  data = NULL,
  stat = "circle",
  position = "identity",
  n = 360,
  expand = 0,
  radius = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{n}{The number of points on the generated path per full circle.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{expand}{A numeric or unit vector of length one, specifying the
expansion amount. Negative values will result in contraction instead. If the
value is given as a numeric it will be understood as a proportion of the
plot area width.}

\item{radius}{As \code{expand} but specifying the corner radius.}
}
\description{
This set of stats and geoms makes it possible to draw circles based on a
center point and a radius. In contrast to using
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}, the size of the circles are related to the
coordinate system and not to a separate scale. These functions are intended
for cartesian coordinate systems and will only produce a true circle if
\code{\link[ggplot2:coord_fixed]{ggplot2::coord_fixed()}} is used.
}
\note{
If the intend is to draw a bubble chart then use
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} and map a variable to the size scale
}
\section{Aesthetics}{

geom_circle understand the following aesthetics (required aesthetics are in
bold):
\itemize{
\item \strong{x0}
\item \strong{y0}
\item \strong{r}
\item color
\item fill
\item linewidth
\item linetype
\item alpha
\item lineend
}
}

\section{Computed variables}{


\describe{
\item{x, y}{The start coordinates for the segment}
}
}

\examples{
# Lets make some data
circles <- data.frame(
  x0 = rep(1:3, 3),
  y0 = rep(1:3, each = 3),
  r = seq(0.1, 1, length.out = 9)
)

# Behold some circles
ggplot() +
  geom_circle(aes(x0 = x0, y0 = y0, r = r, fill = r), data = circles)

# Use coord_fixed to ensure true circularity
ggplot() +
  geom_circle(aes(x0 = x0, y0 = y0, r = r, fill = r), data = circles) +
  coord_fixed()

}
\seealso{
\code{\link[=geom_arc_bar]{geom_arc_bar()}} for drawing arcs with fill
}
