% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fortify_surv.R
\name{fortify.survfit}
\alias{fortify.survfit}
\alias{fortify.survfit.cox}
\title{Convert \code{survival::survfit} to \code{data.frame}}
\usage{
\method{fortify}{survfit}(model, data = NULL, surv.connect = FALSE,
  fun = NULL, ...)
}
\arguments{
\item{model}{\code{survival::survfit} instance}

\item{data}{original dataset, if needed}

\item{surv.connect}{logical frag indicates whether connects survival curve to the origin}

\item{fun}{an arbitrary function defining a transformation of the survival curve}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert \code{survival::survfit} to \code{data.frame}
}
\examples{
library(survival)
fortify(survfit(Surv(time, status) ~ sex, data = lung))
fortify(survfit(Surv(time, status) ~ 1, data = lung))
fortify(survfit(coxph(Surv(time, status) ~ sex, data = lung)))
fortify(survfit(coxph(Surv(time, status) ~ 1, data = lung)))
}

