% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotlib.R
\name{plot_confint}
\alias{plot_confint}
\title{Attach confidence interval to \code{ggplot2::ggplot}}
\usage{
plot_confint(p, data = NULL, lower = "lower", upper = "upper",
  conf.int = TRUE, conf.int.geom = "line", conf.int.colour = "#0000FF",
  conf.int.linetype = "none", conf.int.fill = "#000000",
  conf.int.alpha = 0.3)
}
\arguments{
\item{p}{\code{ggplot2::ggplot} instance}

\item{data}{data contains lower and upper confidence intervals}

\item{lower}{column name for lower confidence interval}

\item{upper}{column name for upper confidence interval}

\item{conf.int}{Logical flag indicating whether to plot confidence intervals}

\item{conf.int.geom}{geometric string for confidence interval. 'line' or 'step'}

\item{conf.int.colour}{line colour for confidence intervals}

\item{conf.int.linetype}{line type for confidence intervals}

\item{conf.int.fill}{fill colour for confidence intervals}

\item{conf.int.alpha}{alpha for confidence intervals}
}
\value{
ggplot
}
\description{
Attach confidence interval to \code{ggplot2::ggplot}
}
\examples{
d <- fortify(stats::acf(AirPassengers, plot = FALSE))
p <- ggplot(data = d, mapping = aes(x = Lag))
ggfortify:::plot_confint(p, data = d)
}

