% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_base.R
\name{autoplot.matrix}
\alias{autoplot.matrix}
\title{Plot \code{base::matrix}}
\usage{
\method{autoplot}{matrix}(object, original = NULL, geom = "tile",
  colour = NULL, size = NULL, alpha = NULL, fill = "#0000FF",
  shape = NULL, label = FALSE, label.label = "rownames",
  label.colour = colour, label.alpha = NULL, label.size = NULL,
  label.angle = NULL, label.family = NULL, label.fontface = NULL,
  label.lineheight = NULL, label.hjust = NULL, label.vjust = NULL,
  label.repel = FALSE, scale = NULL, xlim = c(NA, NA), ylim = c(NA,
  NA), log = "", main = NULL, xlab = NULL, ylab = NULL,
  asp = NULL, ...)
}
\arguments{
\item{object}{\code{base::matrix} instance}

\item{original}{Combined to data by column if provided. Intended to be used for stat functions which
returns not containing original data.}

\item{geom}{Geometric string for plotting. 'tile' or 'point'.}

\item{colour}{colour for points ('point' only)}

\item{size}{point size}

\item{alpha}{alpha}

\item{fill}{fill colour. Ignored if scale keyword is passed. ('tile' Only)}

\item{shape}{point shape}

\item{label}{Logical value whether to display labels}

\item{label.label}{Column name used for label text}

\item{label.colour}{Colour for text labels}

\item{label.alpha}{Alpha for text labels}

\item{label.size}{Size for text labels}

\item{label.angle}{Angle for text labels}

\item{label.family}{Font family for text labels}

\item{label.fontface}{Fontface for text labels}

\item{label.lineheight}{Lineheight for text labels}

\item{label.hjust}{Horizontal adjustment for text labels}

\item{label.vjust}{Vertical adjustment for text labels}

\item{label.repel}{Logical flag indicating whether to use \code{ggrepel}, enabling this may take some time for plotting}

\item{scale}{(Deprecated) \code{ggplot2::scale} instance to plot. ('tile' Only)}

\item{xlim}{limits for x axis}

\item{ylim}{limits for y axis}

\item{log}{which variables to log transform ("x", "y", or "xy")}

\item{main}{character vector or expression for plot title}

\item{xlab}{character vector or expression for x axis label}

\item{ylab}{character vector or expression for y axis label}

\item{asp}{the y/x aspect ratio}

\item{...}{other arguments passed to methods}
}
\value{
ggplot
}
\description{
Plot \code{base::matrix}
}
\examples{
autoplot(matrix(rnorm(20), nc = 5))
autoplot(matrix(rnorm(20), nc = 5), fill = 'red')
autoplot(matrix(rnorm(20), nc = 2), geom = 'point')
}
