% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-ggplot-add.R
\name{theme_stamp}
\alias{theme_stamp}
\title{set the theme of ggplot object with the striped background style.}
\usage{
theme_stamp(colour = c("grey90", "white"), axis = "y", ...)
}
\arguments{
\item{colour}{character the color of the striped background,
default is c('grey90', 'white').}

\item{axis}{character which grid of axis will be filled, default is 'y'.}

\item{...}{additional parameter, see also 'theme' of 'ggplot2'.}
}
\description{
set the theme of ggplot object with the striped background style.
}
\examples{
library(ggplot2)
iris |> tidyr::pivot_longer(
    cols = !Species, 
    names_to = 'var', 
    values_to = 'value'
  ) |>
ggplot(
  aes(x=var, y=Species, color=value, size=value)
) + 
geom_point() -> p
p +
theme_stamp(
  colour = c('grey90', 'white'), 
  axis = 'y',
  axis.line.y=element_line()
)
p +
theme_stamp(
  colour = c('grey90', 'white'),
  axis = 'x',
  axis.line.x = element_line()
)
}
