% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes-coord.r
\name{aes-coord}
\alias{aes-coord}
\alias{aes_coord}
\alias{get_aes_coord}
\alias{aes_c}
\title{Multidimensional coordinate mappings}
\usage{
aes_coord(.data, prefix)

get_aes_coord(data)

aes_c(...)
}
\arguments{
\item{.data, data}{A data frame. \code{.data} stands in for the data passed to
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}, while \code{data} is expected to have been pre-processed
before being passed to a \verb{Stat*$compute_*()} function.}

\item{prefix}{A regular expression used to identify the coordinate columns
of \code{.data}.}

\item{...}{objects to be concatenated.  All \code{\link[base]{NULL}} entries
    are dropped before method dispatch unless at the very beginning of the
    argument list.}
}
\value{
A list with class \code{uneval}. Components of the list are either
quosures or constants.
}
\description{
Allow stat layers to receive a sequence of positional variables
rather than only \code{x} and \code{y}.
}
\details{
These functions coordinate (pun intended) the use of more than two positional
variables in plot layers. Pass multidimensional coordinates to a stat via
\code{mapping = aes_coord(...)} and reconcile the recovered coordinates with \code{x}
and \code{y} (which are overridden if present) in \verb{Stat*$compute_*()}; see the
\link{StatChull} source code for an example. Use \code{aes_c()} to concatenate
aesthetic mappings.
}
\seealso{
\code{\link[ggplot2:aes]{ggplot2::aes()}} for standard \strong{ggplot2} aesthetic mappings.
}
