% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_grid2.R
\name{facet_grid2}
\alias{facet_grid2}
\title{Extended grid facets}
\usage{
facet_grid2(
  rows = NULL,
  cols = NULL,
  scales = "fixed",
  space = "fixed",
  axes = "margins",
  remove_labels = "none",
  independent = "none",
  shrink = TRUE,
  labeller = "label_value",
  as.table = TRUE,
  switch = NULL,
  drop = TRUE,
  margins = FALSE,
  strip = strip_vanilla()
)
}
\arguments{
\item{rows}{A set of variables or expressions quoted by
\code{\link[ggplot2:vars]{vars()}} and defining faceting groups on the rows or columns
dimension. The variables can be named (the names are passed to
\code{labeller}).

For compatibility with the classic interface, \code{rows} can also be
a formula with the rows (of the tabular display) on the LHS and
the columns (of the tabular display) on the RHS; the dot in the
formula is used to indicate there should be no faceting on this
dimension (either row or column).}

\item{cols}{A set of variables or expressions quoted by
\code{\link[ggplot2:vars]{vars()}} and defining faceting groups on the rows or columns
dimension. The variables can be named (the names are passed to
\code{labeller}).

For compatibility with the classic interface, \code{rows} can also be
a formula with the rows (of the tabular display) on the LHS and
the columns (of the tabular display) on the RHS; the dot in the
formula is used to indicate there should be no faceting on this
dimension (either row or column).}

\item{scales}{A \code{character(1)} or \code{logical(1)} whether scales are shared
across facets or allowed to vary. Interacts with the \code{independent}
argument. One of the following:
\describe{
\item{\code{"fixed"} or \code{FALSE}}{Scales are shared across all facets
(default).}
\item{\code{"free_x"}}{x-scales are allowed to vary across rows.}
\item{\code{"free_y"}}{y-scales are allowed to vary across columns.}
\item{\code{"free"} or \code{TRUE}}{Scales can vary across rows and columns.}
}}

\item{space}{A \code{character(1)} or \code{logical(1)} determining whether the size of
panels are proportional to the length of the scales. When the \code{independent}
argument allows for free scales in a dimension, the panel sizes cannot be
proportional. Note that the \code{scales} argument must be free in the same
dimension as the \code{space} argument to have an effect.One of the following:
\describe{
\item{\code{"fixed"} or \code{FALSE}}{All panels have the same size (default).}
\item{\code{"free_x"}}{Panel widths are proportional to the x-scales.}
\item{\code{"free_y"}}{Panel heights are proportional to the y-scales.}
\item{\code{"free"} or \code{TRUE}}{Both the widths and heights vary according to
scales.}
}}

\item{axes}{A \code{character(1)} or \code{logical(1)} where axes should be drawn. One
of the following:
\describe{
\item{\code{"margins"} or \code{FALSE}}{Only draw axes at the outer margins
(default).}
\item{\code{"x"}}{Draw axes at the outer margins and all inner x-axes too.}
\item{\code{"y"}}{Draw axes at the outer margins and all inner y-axes too.}
\item{\code{"all"} or \code{TRUE}}{Draw the axes for every panel.}
}}

\item{remove_labels}{A \code{character(1)} or \code{logical(1)} determining whether
axis text is displayed at inner panels. One of the following:
\describe{
\item{\code{"none"} or \code{FALSE}}{Display axis text at all axes (default).}
\item{\code{"x"}}{Display axis text at outer margins and all inner y-axes.}
\item{\code{"y"}}{Display axis text at outer margins and all inner x-axes.}
\item{\code{"all"} or \code{TRUE}}{Only display axis text at the outer margins.}
}}

\item{independent}{A \code{character(1)} or \code{logical(1)} determining whether
scales can vary within a row or column of panels, like they can be in
\link[ggplot2:facet_wrap]{ggplot2::facet_wrap}. The \code{scales} argument must be free for the same
dimension before they can be set to independent. One of the following:
\describe{
\item{\code{"none"} or \code{FALSE}}{All y-scales should be fixed in a row and all
x-scales are fixed in a column (default).}
\item{\code{"x"}}{x-scales are allowed to vary within a column.}
\item{\code{"y"}}{y-scales are allowed to vary within a row.}
\item{\code{"all"} or \code{TRUE}}{Both x- and y-scales are allowed to vary within
a column or row respectively.}
}}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:labellers]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:labellers]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{switch}{By default, the labels are displayed on the top and
right of the plot. If \code{"x"}, the top labels will be
displayed to the bottom. If \code{"y"}, the right-hand side
labels will be displayed to the left. Can also be set to
\code{"both"}.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{margins}{Either a logical value or a character
vector. Margins are additional facets which contain all the data
for each of the possible values of the faceting variables. If
\code{FALSE}, no additional facets are included (the
default). If \code{TRUE}, margins are included for all faceting
variables. If specified as a character vector, it is the names of
variables for which margins are to be created.}

\item{strip}{An object created by a call to a strip function, such as
\code{\link[=strip_vanilla]{strip_vanilla}}.}
}
\value{
A \code{Facet} ggproto object that can be added to a plot.
}
\description{
This function behaves like \link[ggplot2:facet_grid]{ggplot2::facet_grid} with default arguments, but
has a few extra options. It can draw partial or full axis guides at inner
panels, and position scales can be independent.
}
\details{
Both the \code{independent} and \code{space} arguments only have an effect
when the \code{scales} argument in a dimension is free. However, the
\code{independent} and \code{space} arguments can \emph{not} be used to simultaneously set
an independent scale and have the panel size be proportional to that scale.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) + geom_point()

# Repeat all axes for every facet
p + facet_grid2(cyl ~ drv, axes = "all")

# Repeat only y-axes
p + facet_grid2(cyl ~  drv, axes = "y")

# Repeat axes without x-labels
p + facet_grid2(cyl ~ drv, axes = "all", remove_labels = "x")

# Grid facets with independent axes for every panel
p + facet_grid2(cyl ~ drv, scales = "free", independent = "all")
}
\seealso{
Other facetting functions: 
\code{\link{facet_manual}()},
\code{\link{facet_nested_wrap}()},
\code{\link{facet_nested}()},
\code{\link{facet_wrap2}()}
}
\concept{facetting functions}
