% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghalfnorm.R
\name{gghalfnorm}
\alias{gghalfnorm}
\title{Half Normal Plot}
\usage{
gghalfnorm(x, nlab = 2, labs = as.character(seq_along(x)), repel = FALSE,
  ...)
}
\arguments{
\item{x}{A vector of residuals.}

\item{nlab}{The number of points to label.}

\item{labs}{The labels for the points.}

\item{repel}{Logical. Whether to repel the labels or not.}

\item{...}{Additional parameters to be passed to
\code{\link[ggrepel]{geom_text_repel}}.}
}
\description{
Produce a Half Normal Plot for a vector of residuals.
}
\examples{
set.seed(100)
gghalfnorm(x = rnorm(100), nlab = 10)
gghalfnorm(x = rnorm(100), nlab = 10, repel = TRUE)

}
\seealso{
\code{\link[stats]{qqnorm}}
}

