% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_raster_interactive.R
\name{geom_raster_interactive}
\alias{geom_raster_interactive}
\title{Create interactive raster rectangles}
\usage{
geom_raster_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link[=interactive_parameters]{interactive_parameters()}}.}
}
\description{
The geometry is based on \code{\link[=geom_raster]{geom_raster()}}.
See the documentation for those functions for more details.
}
\section{Details for geom_*_interactive functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[=aes]{aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive raster to a ggplot -------
library(ggplot2)
library(ggiraph)

df <- expand.grid(x = 0:5, y = 0:5)
df$z <- runif(nrow(df))

gg <- ggplot(df, aes(x, y, fill = z, tooltip = "tooltip")) +
  geom_raster_interactive() +
  scale_fill_gradient_interactive(
    data_id = "coco", onclick = "cici", tooltip = "cucu"
  )

x <- girafe(ggobj = gg)
if( interactive() ) print(x)
}
\seealso{
\code{\link[=girafe]{girafe()}}

\code{\link[=girafe]{girafe()}}
}
