% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggRadar.R
\name{ggRadar}
\alias{ggRadar}
\title{Draw a radar chart}
\usage{
ggRadar(data, mapping = NULL, rescale = TRUE, legend.position = "top",
  colour = "red", alpha = 0.3, size = 3, ylim = NULL,
  scales = "fixed", use.label = FALSE, interactive = FALSE, ...)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{rescale}{A logical value. If TRUE, all continuous variables in the data.frame are rescaled.}

\item{legend.position}{Legend position. One of c("top","bottom","left","right","none")}

\item{colour}{A name of color to be assigned as a color variable}

\item{alpha}{Any numbers from 0 (transparent) to 1 (opaque)}

\item{size}{Point size}

\item{ylim}{A numeric vector of length 2, giving the y coordinates ranges.}

\item{scales}{should Scales be fixed ("fixed", the default), free ("free"), or free in one dimension ("free_x", "free_y")}

\item{use.label}{Logical. Whether or not use column label}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{...}{other arguments passed on to geom_point}
}
\value{
An interactive radar plot
}
\description{
Draw a radar chart
}
\examples{
require(ggplot2)
require(ggiraph)
require(plyr)
require(reshape2)
require(moonBook)
require(sjmisc)
ggRadar(data=iris,aes(group=Species))
ggRadar(data=mtcars,interactive=TRUE)
ggRadar(data=mtcars,aes(colour=am,facet=cyl),interactive=TRUE)
ggRadar(data=acs,aes(colour=Dx,facet=Dx))
ggRadar(iris,aes(x=c(Sepal.Length,Sepal.Width,Petal.Length,Petal.Width)))
}
