% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta.R
\name{gr_eta_lasso_fullrank}
\alias{gr_eta_lasso_fullrank}
\alias{fn_eta_lasso_fullrank}
\title{Functions related to eta parameter used in optim and kkt checks}
\usage{
gr_eta_lasso_fullrank(eta, sigma2, beta, eigenvalues, x, y, nt)

fn_eta_lasso_fullrank(eta, sigma2, beta, eigenvalues, x, y, nt)
}
\arguments{
\item{eta}{current estimate of the eta parameter}

\item{sigma2}{current estimate of the sigma2 parameter}

\item{beta}{current estimate of the beta parameter including the intercept.
this should be of length p+1, where p is the number of variables.}

\item{eigenvalues}{non-zero eigenvalues of the kinship matrix, or the square
of the singular values of the matrix used to construct the kinship matrix}

\item{x}{input matrix, of dimension n x p; where n is the number of
observations and p are the number of predictors.}

\item{y}{response variable. must be a quantitative variable}

\item{nt}{total number of observations}
}
\description{
Used for gradient of eta. Currently being passed to optim in
  \code{\link{lmmlasso}} and used in \code{\link{kkt_check}}
}
\seealso{
\code{\link{logliklasso}}, \code{\link{kkt_check}}, \code{\link{lmmlasso}}
}
