% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SupplementaryFunctions.R
\name{branch_singles}
\alias{branch_singles}
\title{Add branches of length zero to get rid of single nodes in an adjacency matrix}
\usage{
branch_singles(edges)
}
\arguments{
\item{edges}{Dataframe comprising an adjacency matrix, with column names "Parent" and "Identity"}
}
\value{
A dataframe comprising the augmented adjacency matrix.
}
\description{
Single nodes are those with exactly one daughter. 
This function is required by adj_matrix_to_tree, 
since valid "phylo" objects cannot contain single nodes. 
If pre-existing branches lack lengths then these are set to 1.
}
\examples{
edges1 <- data.frame(Parent = c(1,1,1,3), Identity = 2:5)
branch_singles(edges1)

}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
