% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{move_right}
\alias{move_right}
\title{Move to sibling in adjacency matrix}
\usage{
move_right(edges, identity)
}
\arguments{
\item{edges}{Dataframe comprising an adjacency matrix, with column names "Parent" and "Identity"}

\item{identity}{number or character string specifying whose sibling is to be found}
}
\value{
The sibling's Identity.
}
\description{
Returns the next Identity value among the sorted set of siblings. 
When there is no such sibling, returns the input Identity.
}
\examples{
edges1 <- data.frame(Parent = c(1,1,1,3,3), Identity = 2:6)
move_right(edges1, 3)

}
\seealso{
\code{\link{move_up}} \code{\link{move_down}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
