% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_ggparliament.R
\name{theme_ggparliament}
\alias{theme_ggparliament}
\title{A theme for ggparliament}
\usage{
theme_ggparliament(legend, background_colour, border)
}
\arguments{
\item{legend}{If legend = `TRUE`, add legend to plot. Defaults to `TRUE`.}

\item{background_colour}{If background colour = `TRUE`, fill panel with a grey background. Defaults to `FALSE`.}

\item{border}{If `TRUE` add panel border. Defaults to `FALSE`.}
}
\description{
Calls the ggparliament theme. A reconstructed opinionated theme_void() ggplot2 theme.
}
\examples{
data <- election_data[
  election_data$country == "USA" &
  election_data$house == "Representatives" &
  election_data$year == "2016",
]
usa_data <- parliament_data(
  election_data = data,
  type = "semicircle",
  party_seats = data$seats,
  parl_rows = 8
)
ggplot2::ggplot(usa_data, ggplot2::aes(x, y, colour = party_long)) +
  geom_parliament_seats() +
  geom_highlight_government(government == 1) +
  theme_ggparliament(legend = TRUE, background_colour = TRUE, border = TRUE)
}
\author{
Zoe Meers
}
