\name{geom_boxplot}
\alias{geom_boxplot}
\alias{GeomBoxplot}
\title{geom\_boxplot}
\description{Box and whiskers plot}
\details{
This page describes geom\_boxplot, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with geom\_boxplot.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{geom\_boxplot(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{x}: x position (\strong{required}) 
  \item \code{lower}: NULL (\strong{required}) 
  \item \code{upper}: NULL (\strong{required}) 
  \item \code{middle}: NULL (\strong{required}) 
  \item \code{ymin}: minimum of interval (\strong{required}) 
  \item \code{ymax}: maximum of interval (\strong{required}) 
  \item \code{weight}: observation weight used in statistical transformation 
  \item \code{colour}: border colour 
  \item \code{fill}: internal colour 
  \item \code{size}: size 
}
}
\usage{geom_boxplot(mapping=NULL, data=NULL, stat="boxplot", position="dodge", outlier.colour="black", outlier.shape=16, outlier.size=1, ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{stat}{statistic used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{outlier.colour}{colour for outlying points}
 \item{outlier.shape}{shape of outlying points}
 \item{outlier.size}{size of outlying points}
 \item{...}{other arguments}
}
\seealso{\itemize{
  \item \code{\link{stat_quantile}}: View quantiles conditioned on a continuous variable
  \item \code{\link{geom_jitter}}: Another way to look at conditional distributions
  \item \url{http://had.co.nz/ggplot2/geom_boxplot.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
p <- ggplot(mtcars, aes(factor(cyl), mpg))

p + geom_boxplot()
qplot(factor(cyl), mpg, data = mtcars, geom = "boxplot")

p + geom_boxplot() + geom_jitter()
p + geom_boxplot() + coord_flip()
qplot(factor(cyl), mpg, data = mtcars, geom = "boxplot") +
  coord_flip()

p + geom_boxplot(outlier.colour = "green", outlier.size = 3)

# Add aesthetic mappings
# Note that boxplots are automatically dodged when any aesthetic is 
# a factor
p + geom_boxplot(aes(fill = cyl))
p + geom_boxplot(aes(fill = factor(cyl)))
p + geom_boxplot(aes(fill = factor(vs)))
p + geom_boxplot(aes(fill = factor(am)))

# Set aesthetics to fixed value
p + geom_boxplot(fill="grey80", colour="#3366FF")
qplot(factor(cyl), mpg, data = mtcars, geom = "boxplot", 
  colour = I("#3366FF"))

# Scales vs. coordinate transforms -------
# Scale transformations occur before the boxplot statistics are computed.
# Coordinate transformations occur afterwards.  Observe the effect on the
# number of outliers.
m <- ggplot(movies, aes(y = votes, x = rating,
   group = round_any(rating, 0.5)))
m + geom_boxplot()
m + geom_boxplot() + scale_y_log10()
m + geom_boxplot() + coord_trans(y = "log10")
m + geom_boxplot() + scale_y_log10() + coord_trans(y = "log10")

# Boxplots with continuous x:
# Use the group aesthetic to group observations in boxplots
qplot(year, budget, data = movies, geom = "boxplot")
qplot(year, budget, data = movies, geom = "boxplot", 
  group = round_any(year, 10, floor))

}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
