% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-fixed.r
\name{coord_fixed}
\alias{coord_fixed}
\alias{coord_equal}
\title{Cartesian coordinates with fixed "aspect ratio"}
\usage{
coord_fixed(ratio = 1, xlim = NULL, ylim = NULL, expand = TRUE)
}
\arguments{
\item{ratio}{aspect ratio, expressed as \code{y / x}}

\item{xlim}{Limits for the x and y axes.}

\item{ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}
}
\description{
A fixed scale coordinate system forces a specified ratio between the
physical representation of data units on the axes. The ratio represents the
number of units on the y-axis equivalent to one unit on the x-axis. The
default, \code{ratio = 1}, ensures that one unit on the x-axis is the same
length as one unit on the y-axis. Ratios higher than one make units on the
y axis longer than units on the x-axis, and vice versa. This is similar to
\code{\link[MASS]{eqscplot}}, but it works for all types of graphics.
}
\examples{
# ensures that the ranges of axes are equal to the specified ratio by
# adjusting the plot aspect ratio

p <- ggplot(mtcars, aes(mpg, wt)) + geom_point()
p + coord_fixed(ratio = 1)
p + coord_fixed(ratio = 5)
p + coord_fixed(ratio = 1/5)

# Resize the plot to see that the specified aspect ratio is maintained
}
