% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-margin-grob.r
\name{geom_x_margin_grob}
\alias{geom_x_margin_grob}
\alias{geom_y_margin_grob}
\title{Add Grobs on the margins}
\usage{
geom_x_margin_grob(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  xintercept,
  sides = "b",
  grob.shift = 0,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)

geom_y_margin_grob(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  yintercept,
  sides = "l",
  grob.shift = 0,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{xintercept, yintercept}{numeric Parameters that control the position of
the marginal points. If these are set, data, mapping and show.legend are
overridden.}

\item{sides}{A character string of length one that controls on which side of
the plot the grob annotations appear on. It can be set to a string
containing one of \code{"t"}, \code{"r"}, \code{"b"} or \code{"l"}, for
top, right, bottom, and left.}

\item{grob.shift}{numeric value expressed in npc units for the shift of the
marginal grob inwards from the edge of the plotting area.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\description{
Marging points can supplement a 2d display with annotations. Marging points
can highligth individual cases or values along a margin. The geometries
\code{geom_x_margin_grob()} and \code{geom_y_margin_grob()} behave similarly
\code{geom_vline()} and \code{geom_hline()} and share their "double
personality" as both annotations and geometries.
}
\examples{
# We can add icons to the margin of a plot to signal events




}
\seealso{
Other Geometries for marginal annotations in ggplots: 
\code{\link{geom_x_margin_arrow}()},
\code{\link{geom_x_margin_point}()}
}
\concept{Geometries for marginal annotations in ggplots}
