% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_stages.r
\name{pivot_stages_longer}
\alias{pivot_stages_longer}
\title{Pivot wide data to long for plotting as Sankey}
\usage{
pivot_stages_longer(
  data,
  stages_from,
  values_from,
  additional_aes_from,
  invert_nodes = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} (or an object inheriting the \code{data.frame} class),
which needs to be pivoted.}

\item{stages_from}{A \code{vector} of column names, which represent the stages.}

\item{values_from}{A \code{vector} of column names, which contains \code{numeric} values
that represent the size of the edges in Sankey diagrams. When there are multiple
values for a single edge, they are summed.}

\item{additional_aes_from}{A \code{vector} of column names of data that you want to
use to decorate elements in your Sankey diagram. This argument is optional. See also
\code{vignette("data_management")} and \code{vignette("decorating")}.}

\item{invert_nodes}{When pivoting information from \code{stages_from}, its data is
converted into a \code{factor}. Set \code{invert_nodes} to \code{TRUE} if you want to invert the
order of the levels of the \code{factor}.}
}
\value{
Returns a \link[dplyr:reexports]{dplyr::tibble} with all the selected columns from \code{data} pivoted.
The stages will be listed in the column named \code{stage} and nodes in the column named
\code{node}. The result will contain two new columns: a column named \code{connector} indicating
whether the row in the \code{tibble} reflects the source of an edge (value \code{'from'}) or
destination of an edge (value \code{'to'}); and a column named \code{edge_id}, containing a
unique identifier for each edge. The \code{edge_id} is required for the plotting routine
in order to identify which edge source should be connected with which edge destination.
}
\description{
Pivot data from a wide to a long format suitable for plotting Sankey diagrams.
}
\details{
Typically, data to be displayed as a Sankey, is collected and stored in a
wide format, where each stage (i.e., x-axis of a Sankey diagram) is in a
column. The \code{ggplot2} philosophy requires the data to be in a long format,
such that diagram decorations (aesthetics) can be mapped to specific
columns.

This function pivots wide data in an appropriate long format, by indicating
which columns contain the stages, and in which order they should appear in
the Sankey.

For more details see \code{vignette("data_management")}
}
\examples{
data("ecosystem_services")

ecosystem_services_p1 <-
  pivot_stages_longer(
    data        = ecosystem_services,
    stages_from = c("activity_type", "pressure_cat",
                    "biotic_group", "service_division"),
    values_from = "RCSES")

## suppose we want to decorate our Sankey
## with information on the 'section' of the services:
ecosystem_services_p2 <-
  pivot_stages_longer(
    data        = ecosystem_services,
    stages_from = c("activity_type", "pressure_cat",
                    "biotic_group", "service_division"),
    values_from = "RCSES",
    additional_aes_from = "service_section")

}
\author{
Pepijn de Vries
}
