% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.generic_spct}
\alias{autoplot.generic_spct}
\alias{autoplot.generic_mspct}
\alias{autoplot.waveband}
\title{Plot a spectrum.}
\usage{
\method{autoplot}{generic_spct}(object, ...)

\method{autoplot}{generic_mspct}(object, ...)

\method{autoplot}{waveband}(object, ...)
}
\arguments{
\item{object}{An R object derived from class \code{generic_spct} or derived
from class \code{generic_mspct}.}

\item{...}{Named arguments passed to \code{plot()} methods.}
}
\value{
a \code{ggplot} object.
}
\description{
This method returns a ggplot object with an annotated plot of an object of a
class derived from \code{generic_spct} or of a class derived from
\code{generic_mspct} for which a \code{plot()} method exists.
}
\details{
Support for \code{autoplot()} method for consistency
  with package 'ggplot2'. Please consult the documentation of the
  \code{plot()} methods for details about use of these autoplot methods.
  They are implemented as simple wrappers that forward the call to
  \code{plot()}.
}
\note{
The generic for this method is defined in package 'ggplot2' and
  specializations for objects of diverse classes are provided by 'ggplot2'
  and other packages.
}
\examples{
library(photobiology)
ggplot2::autoplot(sun.spct, annotations = "")

}
\seealso{
\code{\link{plot.calibration_spct}},  \code{\link{plot.cps_spct}},
 \code{\link{plot.filter_spct}}, \code{\link{plot.raw_spct}},
  \code{\link{plot.response_spct}},  \code{\link{plot.source_spct}} and
   \code{\link{plot.waveband}}.

Other plot functions: \code{\link{plot.calibration_spct}},
  \code{\link{plot.cps_spct}},
  \code{\link{plot.filter_spct}},
  \code{\link{plot.object_spct}},
  \code{\link{plot.raw_spct}},
  \code{\link{plot.reflector_spct}},
  \code{\link{plot.response_spct}},
  \code{\link{plot.source_spct}},
  \code{\link{plot.waveband}}
}
\concept{plot functions}
