% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-filter-spct.r
\name{O_plot}
\alias{O_plot}
\title{Create a complete ggplot for a object spectrum.}
\usage{
O_plot(
  spct,
  w.band,
  range,
  pc.out,
  label.qty,
  span,
  wls.target,
  annotations,
  geom,
  stacked,
  text.size,
  chroma.type,
  facets,
  na.rm,
  ylim
)
}
\arguments{
\item{spct}{an object_spct object.}

\item{w.band}{list of waveband objects.}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm).}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one.}

\item{label.qty}{character string giving the type of summary quantity to use
for labels.}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{wls.target}{numeric vector indicating the spectral quantity values for
which wavelengths are to be searched and interpolated if need. The
\code{character} strings "half.maximum" and "half.range" are also accepted
as arguments. A list with \code{numeric} and/or \code{character} values is
also accepted.}

\item{annotations}{a character vector.}

\item{geom}{character.}

\item{stacked}{logical.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{na.rm}{logical.}

\item{ylim}{numeric y axis limits,}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of an object_spct
displaying spectral transmittance, absorptance and reflectance.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot object, and can be further manipulated.
}
\keyword{internal}
