% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-Xisoprop.R
\docType{data}
\name{geom_Xisoprop}
\alias{GeomLisoprop}
\alias{GeomRisoprop}
\alias{GeomTisoprop}
\alias{geom_Lisoprop}
\alias{geom_Risoprop}
\alias{geom_Tisoprop}
\alias{geom_Xisoprop}
\title{Fixed Value Isoproportion Lines}
\usage{
geom_Tisoprop(mapping = NULL, data = NULL, ..., value, na.rm = FALSE,
  show.legend = NA)

geom_Lisoprop(mapping = NULL, data = NULL, ..., value, na.rm = FALSE,
  show.legend = NA)

geom_Risoprop(mapping = NULL, data = NULL, ..., value, na.rm = FALSE,
  show.legend = NA)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}

\item{value, }{the isoproportion ratio to draw}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}
}
\description{
Create fixed isoproportion lines for each of the ternary axes, \code{geom_Xisoprop(...), (X = T, L, R)} will draw an isoproportion
line projecting from the T, L and R apex respectively.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "Tisoprop")}
}
\examples{
data(Feldspar)
ggtern(data=Feldspar,aes(Ab,An,Or)) +
geom_Tisoprop(value=0.5) +
geom_Lisoprop(value=0.5) +
geom_Risoprop(value=0.5) +
geom_point()
}
\author{
Nicholas Hamilton
}
\keyword{datasets}

