% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density-tern.R, R/stat-density-tern.R
\docType{data}
\name{geom_density_tern}
\alias{geom_density_tern}
\alias{GeomDensityTern}
\alias{stat_density_tern}
\alias{StatDensityTern}
\title{Density Estimate (ggtern version)}
\usage{
geom_density_tern(mapping = NULL, data = NULL, stat = "DensityTern",
  position = "identity", ..., lineend = "butt", linejoin = "round",
  linemitre = 1, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)

stat_density_tern(mapping = NULL, data = NULL, geom = "density_tern",
  position = "identity", ..., contour = TRUE, n = 100, h = NULL,
  bdl = 0, bdl.val = NA, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, weight = 1, base = "ilr", expand = c(0.5,
  0.5))
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{geom}{Use to override the default connection between
\code{geom_density_2d} and \code{stat_density_2d}.}

\item{contour}{If \code{TRUE}, contour the results of the 2d density
estimation}

\item{n}{number of grid points in each direction}

\item{h}{Bandwidth (vector of length two) as a multiple of the best estimate, estimated using \code{\link[MASS]{bandwidth.nrd}}.}

\item{bdl}{the threshold for detection limit. This is applied against the output of \code{\link[compositions]{acomp}} function, 
so it is expected as a fraction in the range [0,1]}

\item{bdl.val}{compositions which have components that are below the detection limit, will have these components replaced by this val. 
If it is NA then these items will be discarded. If the value is something other than 'NA', then all values less than \code{bdl} will
be replaced and therefore included in the final density estimate.}

\item{weight}{weighting for weighted kde2d esimate, default's to 1, which is non-weighted and equivalent to the usual kde2d calculation}

\item{base}{the base transformation of the data, options include 'identity' (ie direct on the cartesian space), or 'ilr'
which means to use the isometric log ratio transformation.}

\item{expand}{Calculate on a mesh which extends beyond the grid of the plot region by this amount
If \code{NULL}, estimated using \code{\link[MASS]{bandwidth.nrd}}.}
}
\description{
Perform a 2D kernel density estimatation using kde2d and display the results with contours. This can be 
useful for dealing with overplotting. Additional weight aesthetic (see aesthetic section below) permits better weighting if desired
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "density_tern")}
}

\examples{
#Plot Density Estimate, on isometric log ratio transformation of original data
data('Feldspar')
ggtern(Feldspar,aes(Ab,An,Or)) + 
 geom_density_tern(aes(color=..level..),bins=5) +
 geom_point()

#Plot Density Estimate w/ Polygon Geometry
data('Feldspar')
ggtern(data=Feldspar,aes(Ab,An,Or)) + 
    stat_density_tern(
        geom='polygon',
        aes(fill=..level..),
        bins=5,
        color='grey') +
    geom_point()
        
}
\author{
Nicholas Hamilton

Nicholas Hamilton
}
\keyword{datasets}
