% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element-markdown.R
\name{element_markdown}
\alias{element_markdown}
\title{Theme element that enables markdown text.}
\usage{
element_markdown(
  family = NULL,
  face = NULL,
  size = NULL,
  colour = NULL,
  fill = NULL,
  box.colour = NULL,
  linetype = NULL,
  linewidth = NULL,
  hjust = NULL,
  vjust = NULL,
  halign = NULL,
  valign = NULL,
  angle = NULL,
  lineheight = NULL,
  margin = NULL,
  padding = NULL,
  r = NULL,
  color = NULL,
  box.color = NULL,
  align_widths = NULL,
  align_heights = NULL,
  rotate_margins = NULL,
  debug = FALSE,
  inherit.blank = FALSE
)
}
\arguments{
\item{family}{Font family}

\item{face}{Font face}

\item{size}{Font size}

\item{colour, color}{Text color}

\item{fill}{Fill color of the enclosing box}

\item{box.colour, box.color}{Line color of the enclosing box (if different from the text color)}

\item{linetype}{Line type of the enclosing box (like \code{lty} in base R)}

\item{linewidth}{Line width of the enclosing box (measured in mm, just like \code{size} in
\code{\link[ggplot2:element_line]{ggplot2::element_line()}}).}

\item{hjust}{Horizontal justification}

\item{vjust}{Vertical justification}

\item{halign}{Horizontal justification}

\item{valign}{Vertical justification}

\item{angle}{Angle (in degrees)}

\item{lineheight}{Line height}

\item{padding, margin}{Padding and margins around the text box.
See \code{\link[gridtext:richtext_grob]{gridtext::richtext_grob()}} for details.}

\item{r}{Unit value specifying the corner radius of the box}

\item{align_widths, align_heights}{Should multiple elements be aligned by their
widths or height? See \code{\link[gridtext:richtext_grob]{gridtext::richtext_grob()}} for details.}

\item{rotate_margins}{Should margins get rotated in frame with rotated text?
If \code{TRUE}, the margins are applied relative to the text direction. If \code{FALSE},
the margins are applied relative to the plot direction, i.e., the top margin,
for example, is always placed above the text label, regardless of the direction
in which the text runs. The default is \code{FALSE}, which mimics the behavior of
\code{element_text()}.}

\item{debug}{Draw a debugging box around each label}

\item{inherit.blank}{See \code{\link[ggplot2:margin]{ggplot2::margin()}} for details.}
}
\value{
A ggplot2 theme element that can be used inside a \code{\link[ggplot2:theme]{ggplot2::theme()}}
call.
}
\description{
Theme element that enables markdown text.
}
\seealso{
\code{\link[gridtext:richtext_grob]{gridtext::richtext_grob()}}, \code{\link[=element_textbox]{element_textbox()}}, \code{\link[=geom_richtext]{geom_richtext()}}
}
