% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtikz.R
\name{ggtikz}
\alias{ggtikz}
\title{Create a canvas and add a TikZ annotation.}
\usage{
ggtikz(gg_plot, ..., draw = TRUE)
}
\arguments{
\item{gg_plot}{A ggplot object on which annotations should be made.}

\item{...}{Passed to \code{\link{ggtikzAnnotation}}.}

\item{draw}{TRUE or FALSE. Should gg_plot and the resulting annotation be
drawn immediately? A tikz device needs to be open.}
}
\value{
A \code{\link{ggtikzCanvas}} object with one
\code{\link{ggtikzAnnotation}} (specified in \code{...}) already added. If
\code{draw = TRUE}, the \code{gg_plot} and the annotations are drawn to the currently
active device. This must be a \code{tikzDevice}, or an error will be raised.
}
\description{
This is a helper function for quick one-step annotations. It creates a
ggtikzCanvas from a ggplot, adds one annotation to it, and optionally
draws the plot and the annotations.
}
\details{
For finer control, see \code{ggtikzCanvas()} and \code{ggtikzAnnotation()}.
}
\examples{
\dontrun{
library(ggplot2)
library(tikzDevice)
library(ggtikz)
p <- ggplot(mtcars, aes(disp, mpg)) + geom_point()
out <- tempfile(fileext = ".tikz")
tikz(out)
# Add a red circle in the middle of the plot.
ggtikz(p, "\\\\fill[red] (0.5,0.5) circle (2mm);", xy="plot")
dev.off()
}
}
\seealso{
\code{\link{ggtikzCanvas}} for creating a canvas which can store
multiple annotations.

\code{\link{ggtikzAnnotation}} for creating an annotation, which can
then be added to a canvas.
}
