% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo.R, R/repo_add_team.R, R/repo_add_user.R,
%   R/repo_collaborators.R, R/repo_contributors.R, R/repo_remove_team.R,
%   R/repo_remove_user.R
\name{repo_user}
\alias{repo_user}
\alias{repo_add_team}
\alias{repo_team_permission}
\alias{repo_add_user}
\alias{repo_user_permission}
\alias{repo_collaborators}
\alias{repo_contributors}
\alias{repo_remove_team}
\alias{repo_remove_user}
\title{GitHub Repository tools - user functions}
\usage{
repo_add_team(
  repo,
  team,
  permission = c("push", "pull", "admin", "maintain", "triage"),
  team_type = c("name", "slug")
)

repo_team_permission(
  repo,
  team,
  permission = c("push", "pull", "admin", "maintain", "triage"),
  team_type = c("name", "slug")
)

repo_add_user(
  repo,
  user,
  permission = c("push", "pull", "admin", "maintain", "triage")
)

repo_user_permission(
  repo,
  user,
  permission = c("push", "pull", "admin", "maintain", "triage")
)

repo_collaborators(repo, include_admins = TRUE)

repo_contributors(repo)

repo_remove_team(repo, team, team_type = c("name", "slug"))

repo_remove_user(repo, user)
}
\arguments{
\item{repo}{Character. Address of repository in \code{owner/repo} format.}

\item{team}{Character. Slug or name of team to add.}

\item{permission}{Character. Permission to be granted to a user or team for repo, defaults to "push".}

\item{team_type}{Character. Either "slug" if the team names are slugs or "name" if full team names are provided.}

\item{user}{Character. One or more GitHub usernames.}

\item{include_admins}{Logical. If \code{FALSE}, user names of users with Admin rights are not included, defaults to \code{TRUE}.}
}
\value{
\code{repo_collaborators()} and \code{repo_contributoes} return a tibble.

All other functions invisibly return a list containing the results of the relevant GitHub API calls.
}
\description{
\itemize{
\item \code{repo_add_user()} - Add a user to a repository
\item \code{repo_remove_user()} - Remove a user from a repository
\item \code{repo_add_team()} - Add a team to a repository
\item \code{repo_remove_team()} - Remove a team from a repository
\item \code{repo_user_permission()} - Change a collaborator's permissions for a repository
\item \code{repo_team_permission()} - Change a team's permissions for a repository
\item \code{repo_collaborators()} - Returns a data frame of repos, their collaborators, and their permissions.
\item \code{repo_contributors()} - Returns a data frame containing details on repository contributor(s).
}
}
\details{
Permissions can be set to any of the following:
\itemize{
\item \code{"pull"} - can pull, but not push to or administer this repository.
\item \code{"push"} - can pull and push, but not administer this repository.
\item \code{"admin"} - can pull, push and administer this repository.
\item \code{"maintain"} - Recommended for project managers who need to manage the repository without access to sensitive or destructive actions.
\item \code{"triage"} - Recommended for contributors who need to proactively manage issues and pull requests without write access.
}
}
\examples{
\dontrun{
repo = repo_create("ghclass-test", "hw1")

team_create("ghclass-test", "team_awesome")

repo_add_user(repo, "rundel")

repo_add_team(repo, "team_awesome")

repo_remove_team(repo, "team_awesome")

repo_collaborators(repo)

repo_contributors(repo)
repo_contributors("rundel/ghclass")

# Cleanup
repo_delete(repo, prompt=FALSE)
}

}
