% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gifski.R
\name{gifski}
\alias{gifski}
\alias{save_gif}
\title{Gifski}
\usage{
gifski(png_files, gif_file = "animation.gif", width = 800, height = 600,
  delay = 1, loop = TRUE, progress = TRUE)

save_gif(expr, gif_file = "animation.gif", width = 800, height = 600,
  delay = 1, loop = TRUE, progress = TRUE, ...)
}
\arguments{
\item{png_files}{vector of png files}

\item{gif_file}{output gif file}

\item{width}{gif width in pixels}

\item{height}{gif height in pixel}

\item{delay}{time to show each image in seconds}

\item{loop}{should the gif play forever (FALSE to only play once)}

\item{progress}{show progress bar}

\item{expr}{an R expression that creates graphics}

\item{...}{other graphical parameters passed to \link{png}}
}
\description{
Gifski converts image frames to high quality GIF animations. Either provide input
png files, or automatically render animated graphics from the R graphics device.
}
\examples{
# Manually convert png files to gif
png_path <- file.path(tempdir(), "frame\%03d.png")
png(png_path)
par(ask = FALSE)
for(i in 1:10)
  plot(rnorm(i * 10), main = i)
dev.off()
png_files <- sprintf(png_path, 1:10)
gif_file <- tempfile(fileext = ".gif")
gifski(png_files, gif_file)
unlink(png_files)
\donttest{utils::browseURL(gif_file)}

\donttest{
# Example borrowed from gganimate
library(gapminder)
library(ggplot2)
makeplot <- function(){
  datalist <- split(gapminder, gapminder$year)
  lapply(datalist, function(data){
    p <- ggplot(data, aes(gdpPercap, lifeExp, size = pop, color = continent)) +
      scale_size("population", limits = range(gapminder$pop)) + geom_point() + ylim(20, 90) +
      scale_x_log10(limits = range(gapminder$gdpPercap)) + ggtitle(data$year) + theme_classic()
    print(p)
  })
}

# High Definition images:
gif_file <- file.path(tempdir(), 'gapminder.gif')
save_gif(makeplot(), gif_file, 1280, 720, res = 144)
utils::browseURL(gif_file)}
}
