% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{is_bare}
\alias{is_bare}
\alias{is_bare,git_repository-method}
\alias{is_bare,missing-method}
\title{Check if repository is bare}
\usage{
is_bare(repo)

\S4method{is_bare}{git_repository}(repo)

\S4method{is_bare}{missing}()
}
\arguments{
\item{repo}{The repository \code{object}
\code{\linkS4class{git_repository}} to check if it's bare. If the
\code{repo} argument is missing, the repository is searched for
with \code{\link{discover_repository}} in the current working
directory.}
}
\value{
TRUE if bare repository, else FALSE
}
\description{
Check if repository is bare
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
is_bare(repo)

## Initialize a bare repository
path_bare <- tempfile(pattern="git2r-")
dir.create(path_bare)
repo_bare <- init(path_bare, bare = TRUE)
is_bare(repo_bare)
}
}
\seealso{
\link{init}
}
\keyword{methods}

