% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.gitter}
\alias{plot.gitter}
\title{Plot a gitter dat file}
\usage{
\method{plot}{gitter}(x, title = "", type = "heatmap", low = "turquoise",
  mid = "black", high = "yellow", show.text = F, text.color = "white",
  norm = T, show.flags = T, flag.color = "white", ...)
}
\arguments{
\item{x}{The data.frame produced by \code{\link{gitter}} or the path to a dat file saved by \code{\link{gitter}}.}

\item{title}{Title of plot. Default is blank.}

\item{type}{Type of plot. "heatmap" for a heatmap, "bubble" for a bubble plot. Default is "heatmap".}

\item{low}{Color for the lower bound of colony sizes. Default is "turquoise".}

\item{mid}{Color of the middle value of colony sizes. Default is "black".}

\item{high}{Color for the upper bound of colony sizes. Default is "yellow".}

\item{show.text}{Logical indicating if text representation of colony sizes should be overlaid on the plot. Default is \code{TRUE}.}

\item{text.color}{Color of text if show.text is \code{TRUE}. Default is "white".}

\item{norm}{Logical indicating if colony sizes should be normalized by dividing colony sizes the middle mean of values and capping them between 0-2. Default is \code{TRUE}.}

\item{show.flags}{Logical indicating if dots should be overlaid on the plot for flagged colonies. Default is \code{TRUE}.}

\item{flag.color}{Color of flag dot if show.flags is \code{TRUE}. Default is "white".}

\item{...}{Additional arguments. Not used.}
}
\value{
a ggplot heatmap or bubble plot.
}
\description{
This function will plot a heatmap or bubble plot of a data.frame produced by \code{\link{gitter}} or a dat file saved to disk.
}
\examples{
f = system.file("extdata", "sample.jpg.dat", package="gitter")
# Read in path as a gitter data object
g = gitter.read(f)
# Plot a heatmap
plot(g, type="heatmap")
# Show a bubble plot
plot(g, type="bubble", low="black", high="red")
}
\keyword{bubble}
\keyword{display}
\keyword{heatmap}
\keyword{plot}
\keyword{visualize}

