% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.glca.R
\name{plot.glca}
\alias{plot.glca}
\title{Plots the Estimated Parameters of Fitted glca Model}
\usage{
\method{plot}{glca}(x, group.name = NULL, ...)
}
\arguments{
\item{x}{an object of "\code{glca}", usually, a result of a call to \code{glca}}

\item{group.name}{a vector of strings which indicates groups, rho-parameters of which will be printed when \code{measure.inv = FALSE}.}

\item{...}{further arguments passed to or from other methods}
}
\value{
This function plots estimated parameters of model.
}
\description{
\code{plot} method for class "\code{glca}".
}
\examples{
\dontrun{
# LCA
lca = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ 1,
            data = gss, nclass = 3, na.rm = TRUE)
plot(lca)

# Multitple Group LCA (MGLCA)
mglca1 = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ 1,
             group = DEGREE, data = gss, nclass = 3)
plot(mglca1)

# Multitple Group LCA (MGLCA) (measure.inv = FALSE)
mglca2 = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ 1,
             group = DEGREE, data = gss, nclass = 3, measure.inv = FALSE)
plot(mglca2)
plot(mglca2, "all")

# Multilvel LCA (MLCA)
mlca = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ 1,
             group = REGION, data = gss, nclass = 3, ncluster = 2)
plot(mlca)
}

}
\seealso{
\code{\link{glca}}
}
