% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetClassDefn.R, R/methods.R
\docType{class}
\name{pglmmObj-class}
\alias{pglmmObj-class}
\alias{pglmmObj}
\alias{show,}
\alias{pglmmObj-method,}
\alias{coef.pglmmObj,}
\alias{fitted.pglmmObj,}
\alias{fixef.pglmmObj,}
\alias{formula.pglmmObj,}
\alias{logLik.pglmmObj,}
\alias{model.frame.pglmmObj,}
\alias{model.matrix.pglmmObj,}
\alias{plot.pglmmObj,}
\alias{predict.pglmmObj,}
\alias{print.pglmmObj,}
\alias{ranef.pglmmObj,}
\alias{residuals.pglmmObj,}
\alias{sigma.pglmmObj,}
\alias{summary.pglmmObj}
\alias{fixef.pglmmObj}
\alias{ranef.pglmmObj}
\alias{sigma.pglmmObj}
\alias{coef.pglmmObj}
\alias{family.pglmmObj}
\alias{nobs.pglmmObj}
\alias{ngrps.pglmmObj}
\alias{formula.pglmmObj}
\alias{model.frame.pglmmObj}
\alias{model.matrix.pglmmObj}
\alias{fitted.pglmmObj}
\alias{predict.pglmmObj}
\alias{residuals.pglmmObj}
\alias{print.pglmmObj}
\alias{logLik.pglmmObj}
\alias{BIC.pglmmObj}
\alias{plot.pglmmObj}
\title{Class \code{pglmmObj} of Fitted Penalized Generalized Mixed-Effects Models for 
package \code{glmmPen}}
\usage{
\method{fixef}{pglmmObj}(object)

\method{ranef}{pglmmObj}(object)

\method{sigma}{pglmmObj}(object, ...)

\method{coef}{pglmmObj}(object, ...)

\method{family}{pglmmObj}(object, ...)

\method{nobs}{pglmmObj}(object, ...)

\method{ngrps}{pglmmObj}(object, ...)

\method{formula}{pglmmObj}(x, fixed.only = FALSE, random.only = FALSE, ...)

\method{model.frame}{pglmmObj}(formula, fixed.only = FALSE, ...)

\method{model.matrix}{pglmmObj}(object, type = c("fixed", "random"), ...)

\method{fitted}{pglmmObj}(object, fixed.only = TRUE, ...)

\method{predict}{pglmmObj}(
  object,
  newdata = NULL,
  type = c("link", "response"),
  fixed.only = TRUE,
  ...
)

\method{residuals}{pglmmObj}(object, type = c("deviance", "pearson", "response", "working"), ...)

\method{print}{pglmmObj}(x, digits = c(fef = 4, ref = 4), ...)

\method{summary}{pglmmObj}(
  object,
  digits = c(fef = 4, ref = 4),
  resid_type = switch(object$family$family, gaussian = "pearson", "deviance"),
  ...
)

\method{logLik}{pglmmObj}(object, ...)

\method{BIC}{pglmmObj}(object, ...)

\method{plot}{pglmmObj}(x, fixed.only = FALSE, type = NULL, ...)
}
\arguments{
\item{object}{pglmmObj object output from \code{glmm}, \code{glmmPen}, or \code{glmmPen_FineSearch}}

\item{...}{potentially further arguments passed from other methods}

\item{x}{an R object of class \code{pglmmObj}}

\item{fixed.only}{logical value; default \code{TRUE} indicates that only the fixed effects 
should be used in the fitted value/prediction, while \code{FALSE} indicates that both the fixed and 
random effects should be used in the fitted value/prediction}

\item{random.only}{logical value used in \code{formula}; \code{TRUE} indicates that 
only the formula elements relating to the random effects should be returned}

\item{formula}{in the case of model.frame, a \code{pglmmObj} object}

\item{type}{See details of \code{type} options for each function under "Functions" section.}

\item{newdata}{optional new data.frame containing the same variables used in the model fit procedure}

\item{digits}{number of significant digits for printing; default of 4}

\item{resid_type}{type of residuals to summarize in output. See \code{predict.pglmmObj}
for residual options available.}
}
\value{
The pglmmObj object returns the following items:
\item{fixef}{vector of fixed effects coefficients}
\item{ranef}{matrix of random effects coefficients for each 
explanatory variable for each level of the grouping factor}
\item{sigma}{random effects covariance matrix}
\item{scale}{if family is Gaussian, returns the residual error variance}
\item{posterior_samples}{Samples from the posterior distribution of the random effects,
taken at the end of the model fit (after convergence or after maximum iterations allowed).
Can be used for diagnositics purposes. Note: These posterior samples are from a single chain.}
\item{sampling}{character string for type of sampling used to calculate the posterior samples
in the E-step of the algorithm}
\item{results_all}{matrix of results from all model fits during variable selection (if selection
performed). Output for each model includes: penalty parameters for fixed (lambda0) and random 
(lambda1) effects, BIC-derived quantities and the log-likelihood 
(note: the arguments \code{BIC_option} and \code{logLik_calc} in \code{\link{selectControl}}
determine which of these quantities are calculated for each model), 
the number of non-zero fixed and random effects (includes intercept),
number of EM iterations used for model fit, whether or not the 
model converged (0 for no vs 1 for yes), and the fixed and random effects coefficients}
\item{results_optim}{results from the 'best' model fit; see results_all for details. 
BICh, BIC, BICNgrp, and LogLik computed for this best model if not previously calculated.}
\item{family}{Family}
\item{penalty_info}{list of penalty information}
\item{call}{arguments plugged into \code{glmm}, \code{glmmPen}, or \code{glmmPen_FineSearch}}
\item{formula}{formula}
\item{fixed_vars}{names of fixed effects variables}
\item{data}{list of data used in model fit, including the response y, the fixed effects 
covariates matrix X, the random effects model matrix Z (which is composed of values from the 
standardized fixed effects model matrix), 
the grouping factor, offset, model frame,
and standarization information used to standardize the fixed effects covariates}
\item{optinfo}{Information about the optimization of the 'best' model}
\item{control_info}{optimization parameters used for the model fit}
\item{Estep_init}{materials that can be used to initialize another E-step (for 
use in \code{glmmPen_FineSearch})}
\item{Gibbs_info}{list of materials to perform diagnositics on the Metropolis-within-Gibbs
sample chains, including the Gibbs acceptance rates (included for both the independence
and adaptive random walk samplers) and the final proposal standard deviations 
(included for the adaptive random walk sampler only))}

showClass("pglmmObj")
methods(class = "pglmmObj")
}
\description{
The functions \code{\link{glmm}}, \code{\link{glmmPen}}, and 
\code{\link{glmmPen_FineSearch}} from the package \code{glmmPen} 
output the reference class object of type \code{pglmmObj}.
}
\section{Functions}{
\itemize{
\item \code{fixef.pglmmObj}: Provides the fixed effects coefficients

\item \code{ranef.pglmmObj}: Provides the random effects coefficients for each explanatory variable
for each level of the grouping factor

\item \code{sigma.pglmmObj}: Provides the random effect covariance matrix. If family is Gaussian,
also returns the standard deviation of the residual error.

\item \code{coef.pglmmObj}: Computes the sum of the random and fixed effects 
coefficients for each explanatory variable for each level of each grouping factor.

\item \code{family.pglmmObj}: Family of the fitted GLMM

\item \code{nobs.pglmmObj}: Number of observations used in the model fit

\item \code{ngrps.pglmmObj}: Number of levels in the grouping factor

\item \code{formula.pglmmObj}: Formula used for the model fit. Can return the full
formula, or just the formula elements relating to the fixed effects
(fixed.only = TRUE) or random effects (random.only = TRUE)

\item \code{model.frame.pglmmObj}: Returns the model frame

\item \code{model.matrix.pglmmObj}: Returns the model matrix of either the fixed (type = "fixed") or 
random effects (type = "random")

\item \code{fitted.pglmmObj}: Fitted values

\item \code{predict.pglmmObj}: Predictions for the pglmmObj output object from the glmmPen package functions.
Argument \code{type}: character string for type of predictors: "link", which generates the linear predictor,
and "response", which generates the expected mean values of the response.

\item \code{residuals.pglmmObj}: Residuals for the pglmmObj output object from the glmmPen package functions.
Argument \code{type}: character string for type of residuals to report. Options include "deviance" (default), 
"pearson", "response", and "working", which specify the deviance residuals, Pearson residuals,
the difference between the actual response y and the expected mean response (y - mu), and the
working residuals (y - mu) / mu

\item \code{print.pglmmObj}: Prints a selection of summary information of fitted model

\item \code{summary.pglmmObj}: Returns a list of summary statistics of the fitted model.

\item \code{logLik.pglmmObj}: Returns the log-likelihood using the Corrected Arithmetic Mean estimator
with importance sampling weights developed by Pajor (2017). Degrees of freedom
give the sum of the non-zero fixed and random effects coefficients.
Citation: Pajor, A. (2017). Estimating the marginal likelihood using the arithmetic mean identity. 
Bayesian Analysis, 12(1), 261-287.

\item \code{BIC.pglmmObj}: Returns BIC, BICh (hybrid BIC developed by Delattre et al., citation:
Delattre, M., Lavielle, M., & Poursat, M. A. (2014). A note on BIC in mixed-effects models. 
Electronic journal of statistics, 8(1), 456-475.), BICNgrps (BIC using N = number of groups
in the penalty term), and possibly BIC-ICQ (labeled as "BICq") if the argument \code{BIC_option}
was set to "BICq" in \code{\link{selectControl}} (citation for BIC-ICQ: 
Ibrahim, J. G., Zhu, H., Garcia, R. I., & Guo, R. (2011). 
Fixed and random effects selection in mixed effects models. Biometrics, 67(2), 495-503.)

\item \code{plot.pglmmObj}: Plot residuals for the pglmmObj output object from the glmmPen package.
Argument \code{type}: character string for type of residuals to report. Options include "deviance" 
(default for non-Gaussian family), "pearson" (default for Gaussian family), 
"response", and "working", which specify the deviance residuals, Pearson residuals,
the difference between the actual response y and the expected mean response (y - mu), and the
working residuals (y - mu) / mu
}}


\keyword{classes}
