% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmSeq.R
\name{lmmSeq}
\alias{lmmSeq}
\title{Linear mixed models for data matrix}
\usage{
lmmSeq(
  modelFormula,
  maindata,
  metadata,
  id = NULL,
  offset = NULL,
  test.stat = c("Wald", "F"),
  reducedFormula = "",
  modelData = NULL,
  designMatrix = NULL,
  control = lmerControl(),
  cores = 1,
  removeSingles = FALSE,
  verbose = TRUE,
  returnList = FALSE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{modelFormula}{the model formula. This must be of the form \code{"~ ..."}
where the structure is assumed to be \code{"gene ~ ..."}. The formula must
include a random effects term. See formula structure for random effects in
\code{\link[lme4:lmer]{lme4::lmer()}}}

\item{maindata}{data matrix with genes in rows and samples in columns}

\item{metadata}{a dataframe of sample information with variables in columns
and samples in rows}

\item{id}{Optional. Used to specify the column in metadata which contains the
sample IDs to be used in repeated samples for random effects. If not
specified, the function defaults to using the variable after the "|" in the
random effects term in the formula.}

\item{offset}{Vector containing model offsets (default = NULL). If provided
the \code{lmer()} offset is set to \code{offset}. See
\code{\link[lme4:lmer]{lme4::lmer()}}}

\item{test.stat}{Character value specifying test statistic. Current options
are "Wald" for type 2 Wald Chi square test using code derived and modified
from \link[car:Anova]{car::Anova} to improve speed for matrix tests. Or "F" for conditional
F tests using Saiterthwaite's method of approximated Df. This uses
\link[lmerTest:lmer]{lmerTest::lmer} and is somewhat slower.}

\item{reducedFormula}{Optional design formula without random effects. If not
given, it is automatically generated by removing the random effects from
the main formula. Used to calculate confidence intervals for final fitted
models on each gene for plotting purposes.}

\item{modelData}{Optional dataframe. Default is generated by call to
\code{expand.grid} using levels of variables in the formula. Used to calculate
model predictions (estimated means & 95\% CI) for plotting via \link{modelPlot}.
It can therefore be used to add/remove points in \link{modelPlot}.}

\item{designMatrix}{Optional custom design matrix generated by call to
\code{model.matrix} using \code{modelData} and \code{reducedFormula}. Used to calculate
model predictions for plotting.}

\item{control}{the \code{lmer} optimizer control (default = \code{lmerControl()}). See
\code{\link[lme4:lmerControl]{lme4::lmerControl()}}.}

\item{cores}{number of cores to use for parallelisation. Default = 1.}

\item{removeSingles}{whether to remove individuals with no repeated measures
(default = FALSE)}

\item{verbose}{Logical whether to display messaging (default = TRUE)}

\item{returnList}{Logical whether to return results as a list or lmmSeq
object (default = FALSE). Helpful for debugging.}

\item{progress}{Logical whether to display a progress bar}

\item{...}{Other parameters passed to \code{\link[lme4:lmer]{lme4::lmer()}}}
}
\value{
Returns an S4 class \code{lmmSeq} object with results for gene-wise
linear mixed models; or a list of results if \code{returnList} is \code{TRUE}.
}
\description{
Fits many linear mixed effects models for analysis of gaussian data with
random effects, with parallelisation and optimisation for speed. It is
suitable for longitudinal analysis of high dimensional data. Wald type 2
Chi-squared test is used to calculate p-values.
}
\details{
Two key methods are used to speed up computation above and beyond simple
parallelisation. The first is to speed up \code{\link[lme4:lmer]{lme4::lmer()}} by calling
\link[lme4:modular]{lme4::lFormula} once at the start and then updating the \code{lFormula} output
with new data. The 2nd speed up is through optimised code for repeated type 2
Wald Chi-squared tests (original code was derived from \link[car:Anova]{car::Anova}). For
example, elements such as the hypothesis matrices are generated only once to
reduce unnecessarily repetitive computation, and the generation of p-values
from Chi-squared values is vectorised and performed at the end. F-tests using
the \code{lmerTest} package have not been optimised and are therefore slower.

Parallelisation is performed using \link[parallel:mclapply]{parallel::mclapply} on unix/mac and
\link[parallel:clusterApply]{parallel::parLapply} on windows. Progress bars use \link[pbmcapply:pbmclapply]{pbmcapply::pbmclapply}
on unix/mac and \link[pbapply:pbapply]{pbapply::pblapply} on windows.
}
\examples{
data(PEAC_minimal_load)
logtpm <- log2(tpm +1)
lmmtest <- lmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                     maindata = logtpm[1:2, ],
                     metadata = metadata,
                     verbose = FALSE)
names(attributes(lmmtest))
}
