% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB.R
\name{getReStruc}
\alias{getReStruc}
\title{Calculate random effect structure
Calculates number of random effects, number of parameters,
blocksize and number of blocks.  Mostly for internal use.}
\usage{
getReStruc(reTrms, ss = NULL)
}
\arguments{
\item{reTrms}{random-effects terms list}

\item{ss}{a character string indicating a valid covariance structure. 
Must be one of \code{names(glmmTMB:::.valid_covstruct)};
default is to use an unstructured  variance-covariance
matrix (\code{"us"}) for all blocks).}
}
\value{
a list
\item{blockNumTheta}{number of variance covariance parameters per term}
\item{blockSize}{size (dimension) of one block}
\item{blockReps}{number of times the blocks are repeated (levels)}
\item{covCode}{structure code}
}
\description{
Calculate random effect structure
Calculates number of random effects, number of parameters,
blocksize and number of blocks.  Mostly for internal use.
}
\examples{
data(sleepstudy, package="lme4")
rt <- lme4::lFormula(Reaction~Days+(1|Subject)+(0+Days|Subject),
                    sleepstudy)$reTrms
rt2 <- lme4::lFormula(Reaction~Days+(Days|Subject),
                    sleepstudy)$reTrms
getReStruc(rt)
}
