% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{stepCriterion.lm}
\alias{stepCriterion.lm}
\title{Variable Selection in Normal Linear Models}
\usage{
\method{stepCriterion}{lm}(
  model,
  criterion = c("bic", "aic", "adjr2", "predr2", "cp", "p-value"),
  direction = c("backward", "forward"),
  level = 0.05,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{an object of the class lm which is obtained from the fit of a normal linear model. The linear predictor of the model whose fit is stored in this lm object is the more complex candidate which should be considered by the variable selection procedure.  The more simple model which should be considered by the variable selection procedure is that with just the Intercept, if there is.}

\item{criterion}{an (optional) character string indicating the criterion which should be used to compare the candidate models. The available options are: AIC ("aic"), BIC ("bic"), adjusted R-squared ("adjr2"), predicted R-squared ("predr2"), Mallows' CP ("cp") and \emph{p}-value of the F test ("p-value"). By default, \code{criterion} is set to be "bic".}

\item{direction}{an (optional) character string indicating the mode of variable selection which should be used. The available options are: deleting variables ("backward")  and adding variables ("forward"). By default, \code{direction} is set to be "backward".}

\item{level}{an (optional) numeric value in the interval (0,1) indicating the significance level chosen to perform the F tests. This is only appropiate if \code{criterion="p-value"}. By default, \code{level} is set to be 0.05.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods. For example, \code{k}, that is, the magnitude of the penalty in the AIC, which by default is set to be 2.}
}
\value{
A list which contains the following objects:
\itemize{
\item{\code{initial}:}{ an expression describing the linear predictor of the "initial" model.}
\item{\code{final}:}{ an expression describing the linear predictor of the "final" model.}
\item{\code{criterion}:}{ a character string describing the criterion chosen to compare the candidate models.}
}
}
\description{
Performs variable selection in normal linear models.
}
\examples{
## Example 1
fit1 <- lm(log(Ozone) ~ Solar.R*Temp*Wind, data=airquality)
stepCriterion(fit1, direction="forward", criterion="adjr2")
stepCriterion(fit1, direction="forward", criterion="bic")
stepCriterion(fit1, direction="forward", criterion="p-value", level=0.05)

## Example 2
fit2 <- lm(mpg ~ log(hp)*log(wt)*qsec, data=mtcars)
stepCriterion(fit2, direction="backward", criterion="bic")
stepCriterion(fit2, direction="forward", criterion="cp")
stepCriterion(fit2, direction="backward", criterion="p-value", level=0.05)
}
\seealso{
\link{stepCriterion.glm}, \link{stepCriterion.overglm}, \link{stepCriterion.glmgee}
}
