% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{data_control}
\alias{data_control}
\alias{example_control}
\title{data_control}
\format{
A tibble with 2,400 rows and 5 variables:
\describe{
\item{location}{Column of type \code{character} showing the ISO2 code of
the country or region for which the data was downloaded.}
\item{keyword}{Column of type \code{character} showing the keyword for
which the data was downloaded.}
\item{date}{Column of type \code{integer} showing the date for which the
data was downloaded. Can be transformed into date format with
\code{lubridate::as_date}.\verb{\\item\{hits\}\{Column of type}double\verb{showing search volumes for the respective location-keyword-date combination.\} \\item\{batch\}\{Column of type}integer` showing the number of each
batch.}
}
}
\source{
\url{https://trends.google.com/trends/}
}
\usage{
example_control
}
\description{
The table \emph{data_control} contains the downloaded data for each control
batch. Each line contains the search \emph{hits} for each \emph{keyword} in a
control \emph{batch} for a given \emph{location} and \emph{date}. Global data
gets the value \emph{world} as location. Data is downloaded and automatically
written to the table through the function \code{download_control}. The
function \code{start_db} exports the table \emph{data_control} as database
connection \code{tbl_control} to the package environment \code{gt.env}. Users
can access the database table through \code{dplyr::tbl}.
The sample data included in \code{data_control} was simulated based on actual
Google Trends data.

Example data for the table \emph{data_control} is available as R object
\code{example_control}.
}
\seealso{
\itemize{
\item \code{\link[=download_control]{download_control()}}
\item \code{\link[dplyr:tbl]{dplyr::tbl()}}
}
}
\keyword{datasets}
