% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glossa_analysis.R
\name{glossa_analysis}
\alias{glossa_analysis}
\title{Main Analysis Function for GLOSSA Package}
\usage{
glossa_analysis(
  pa_data = NULL,
  fit_layers = NULL,
  proj_files = NULL,
  study_area_poly = NULL,
  predictor_variables = NULL,
  decimal_digits = NULL,
  scale_layers = FALSE,
  buffer = NULL,
  native_range = NULL,
  suitable_habitat = NULL,
  other_analysis = NULL,
  seed = NA,
  waiter = NULL
)
}
\arguments{
\item{pa_data}{A list of data frames containing presence-absence data.}

\item{fit_layers}{A SpatRaster stack containing model fitting environmental layers.}

\item{proj_files}{A list of file paths containing environmental layers for projection scenarios.}

\item{study_area_poly}{A spatial polygon defining the study area.}

\item{predictor_variables}{A list of predictor variables to be used in the analysis.}

\item{decimal_digits}{An integer specifying the number of decimal places to which coordinates should be rounded.}

\item{scale_layers}{Logical; if TRUE, covariate layers will be scaled based on fit layers.}

\item{buffer}{Buffer value or distance in decimal degrees (arc_degrees).}

\item{native_range}{A vector of scenarios ('fit_layers', 'projections') where native range modeling should be performed.}

\item{suitable_habitat}{A vector of scenarios ('fit_layers', 'projections') where habitat suitability modeling should be performed.}

\item{other_analysis}{A vector of additional analyses to perform (e.g., 'variable_importance', 'functional_responses', 'cross_validation').}

\item{seed}{Optional; an integer seed for reproducibility of results.}

\item{waiter}{Optional; a waiter instance to update progress in a Shiny application.}
}
\value{
A list containing structured outputs from each major section of the analysis, including model data, projections,
variable importance scores, and habitat suitability assessments.
}
\description{
This function wraps all the analysis that the GLOSSA package performs. It processes presence-absence data,
environmental covariates, and performs species distribution modeling and projections under past and future scenarios.
}
