% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottosplit.R
\name{glottosplitmergemeta}
\alias{glottosplitmergemeta}
\title{Split or merge metadata from glottodata (or glottosubdata)}
\usage{
glottosplitmergemeta(glottodata, splitted = NULL)
}
\arguments{
\item{glottodata}{glottodata}

\item{splitted}{if provided, the second element of the list will be joined with glottodata}
}
\value{
A list of length 2 in case only glottodata is provided, and a merged glottodata object otherwise.
}
\description{
Usually, you will run this function twice, once to split metadata from glottodata, and a second time to join it again.
}
\examples{
glottodata <- glottoget("demodata", meta = TRUE)
splitted <- glottosplitmergemeta(glottodata)
merged <- glottosplitmergemeta(glottodata = glottodata, splitted = splitted)
}
\seealso{
glottojoin

glottosimplify
}
