% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_md.R
\name{map_md}
\alias{map_md}
\title{Targeted markdown formatting}
\usage{
map_md(x, f, n)
}
\arguments{
\item{x}{A character vector of strings containing words separated by spaces.}

\item{f}{An emphasizing inline function (e.g., \code{\link[=md_bold]{md_bold()}}).}

\item{n}{A numeric vector describing the positions of the words in \code{x} to be
emphasized with \code{f}.}
}
\value{
A \code{glue} vector of length equal to \code{x} with the \code{n}th word
formatted using \code{f}.
}
\description{
Split a sentence by whitespace and wrap a specific word(s) in a
markdown inline function.
}
\examples{
map_md("Live free or die", n = 4, f = md_bold)
map_md(stringr::sentences[1:3], n = 2, f = md_italic)
map_md(stringr::sentences[4:6], n = 2:3, f = md_italic)
}
