% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-inlines.R
\name{md_strike}
\alias{md_strike}
\title{Markdown strikethrough (extension)}
\usage{
md_strike(x)
}
\arguments{
\item{x}{A character vector of text to be striked through.}
}
\value{
A \code{glue} vector of length equal to \code{x}.
}
\description{
Take a character vector and wrap each element in tildes to create a glue
vector of strikethrough text. This inline is rendered as the \code{<strike>} HTML
tag.
}
\details{
GFM enables the strikethrough extension, where an additional emphasis type is
available. Strikethrough text is any text wrapped in two tildes (\code{~}).
}
\examples{
md_strike("Example")
md_strike(state.name[1:3])
}
\seealso{
Other inline functions: \code{\link{md_autolink}},
  \code{\link{md_bold}}, \code{\link{md_code}},
  \code{\link{md_convert}}, \code{\link{md_disallow}},
  \code{\link{md_escape}}, \code{\link{md_hardline}},
  \code{\link{md_image}}, \code{\link{md_issue}},
  \code{\link{md_italic}}, \code{\link{md_link}},
  \code{\link{md_softline}}, \code{\link{md_text}}

Other markdown extensions: \code{\link{md_issue}},
  \code{\link{md_table}}
}
\concept{inline functions}
\concept{markdown extensions}
