% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialMethodParameters.R
\name{CholeskyDecomposition}
\alias{CholeskyDecomposition}
\title{Create a parameter set specifying a LU decomposition simulation algorithm}
\usage{
CholeskyDecomposition(nsim = 1, ...)
}
\arguments{
\item{nsim}{number of realisations desired}

\item{...}{further parameters, currently ignored}
}
\value{
an S3-list of class "gmCholeskyDecomposition" containing the few elements given as arguments
to the function. This is just a compact way to provide further functions such as \link{predict_gmSpatialModel}
with appropriate triggers for choosing a prediction method or another, in this case for triggering
LU or Cholesky decomposition simulation.
}
\description{
Create a parameter set describing a Cholesky (or LU) decomposition algorithm to two-point simulation,
mostly for covariance or variogram-based gaussian random fields.
}
\examples{
(chols_local = CholeskyDecomposition(nsim=100, nBands=300))
## then run predict(..., pars=chols_local)
}
