% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anamorphosis.R
\name{ana}
\alias{ana}
\title{Flow anamorphosis transform
Compute a transformation that gaussianizes a certain data set}
\usage{
ana(Y, sigma0 = 0.1, sigma1 = 1, steps = 30, sphere = TRUE, weights = NULL)
}
\arguments{
\item{Y}{data set defining the gaussianization}

\item{sigma0}{starting spread of the kernels}

\item{sigma1}{final spread of the kernels}

\item{steps}{number of steps to linearize the transform (default 30 is good)}

\item{sphere}{boolean, should the transform include a spherifization step,
making \code{Y} spherical?}

\item{weights}{weights to incorporate in the compuations, length=nrow(Y)}
}
\value{
a function with arguments \code{(x, inv=FALSE)}, where \code{x} will be the
data to apply the transformation to, and \code{inv=FALSE} will indicate if the direct
or the inverse transformation is desired
}
\description{
Flow anamorphosis transform
Compute a transformation that gaussianizes a certain data set
}
\examples{
library(compositions)
data("jura", package="gstat")
Y = acomp(jura.pred[,c(10,12,13)])
plot(Y)
anafun = ana(Y)
class(anafun)
z = anafun(Y)
plot(z)
y = anafun(z, inv=TRUE)
plot(data.frame(orig=Y,recalc=y))
}
\seealso{
anaForward, anaBackward, sphTrans
}
\author{
K. Gerald van den Boogaart
}
