% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmDataFrameStack.R
\name{swarmPlot}
\alias{swarmPlot}
\title{Plot a swarm of calculated output through a DataFrameStack}
\usage{
swarmPlot(
  X,
  MARGIN = stackDim(X),
  PLOTFUN,
  ...,
  .plotargs = list(type = "l"),
  .parallelBackend = NA
)
}
\arguments{
\item{X}{a \code{\link[=DataFrameStack]{DataFrameStack()}} or anaologous object}

\item{MARGIN}{which dimension defines the stack? it has a good default! change only if you
know what you do}

\item{PLOTFUN}{the elemental calculating function; this must take as input one element
of the stack and return as output the (x,y)-coordinates of the calculated curve for that
element, in a list of two elements}

\item{...}{further parameters to \code{PLOTFUN}}

\item{.plotargs}{either a logical, or else a list of graphical arguments to pass
to \code{\link[=plot.swarmPlot]{plot.swarmPlot()}}; if \code{.plotargs=FALSE} no plot is produced; if \code{.plotargs=TRUE}
a plot with default values is produced;}

\item{.parallelBackend}{NA or a parallelization strategy; currently unstable for certain
operations and platforms.}
}
\value{
Invisibly, this function returns a list of the evaluation of \code{PLOTFUN} on
each element of the stack. If \code{.plotargs} other than \code{FALSE}, then the function calls
\code{\link[=plot.swarmPlot]{plot.swarmPlot()}} to produce a plot.
}
\description{
Take a \code{\link[=DataFrameStack]{DataFrameStack()}} and apply a certain plotting function to each elements of the stack.
The result (typically a curve per each stack element), may then be plotted all together
}
\examples{
dm = list(point=1:100, var=LETTERS[1:2], rep=paste("r",1:5, sep=""))
ar = array(rnorm(1000), dim=c(100,2,5), dimnames = dm)
dfs = DataFrameStack(ar, stackDim="rep")
swarmPlot(dfs, PLOTFUN=function(x) density(x[,1]))
}
