% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extime.R
\name{extime}
\alias{extime}
\title{Calculate the time that was spent on the whole experiment}
\usage{
extime(
  oTree,
  pcode = NULL,
  plabel = NULL,
  group_id = NULL,
  seconds = FALSE,
  rounded = TRUE,
  digits = 2,
  startat = 1,
  tz = "UTC",
  sinfo = "session_code",
  combine = TRUE
)
}
\arguments{
\item{oTree}{A list of data frames that were created by import_otree().}

\item{pcode}{Character. The value of the participant.code variable if the
time should only be calculated for one specified participant.}

\item{plabel}{Character. The value of the participant.label variable if the
time should only be calculated for one specified participant.}

\item{group_id}{Integer. The value of the group_id variable if the
time should only be calculated for one specified group. The group_id
variable can be created with make_ids().}

\item{seconds}{Logical.
TRUE if the output should be in seconds instead of minutes.}

\item{rounded}{Logical. TRUE if the output should be rounded.}

\item{digits}{Integer. The number of digits to which the output
should be rounded.
This parameter has no effect unless rounded = TRUE.}

\item{startat}{Integer or character string "real".
Whether the start of the experiment should be taken from the time at
a certain index of each person's vector of page_indexes in the
Time data frame or from the "time_started"
variable in all_apps_wide ("real"). Important: If integer,
it represents the position within the page index sequence,
not the numeric value of the page_index variable.}

\item{tz}{Character. Time zone.}

\item{sinfo}{Character.
"session_id" to use session ID for additional information in the data frame
of single durations, "session_code" to use session codes, or NULL if no
session column should be shown.}

\item{combine}{Logical. TRUE if all variables referring to epoch time should
be merged, and all variables referring to participant code should
be merged in case data of several versions of oTree are used. If FALSE,
the function returns an error if several oTree versions' data are present.}
}
\value{
This function returns either a single value if only the data of one person
is calculated or a list of information on the time several participants
spent on the experiment.

In this list, you can find the following information:

$mean_duration = The experiment's average duration.

$min_duration = The experiment's minimum duration.

$max_duration = The experiment's maximum duration.

$single_durations = A data frame of all durations that
are used for calculating the min, max, and mean duration.

$messages = All important notes to the calculations.

$only_one_page = A vector of all individuals who only have one time stamp.
}
\description{
Calculate the time spent on the experiment.
If not stated otherwise, the calculation only starts at the end of
the first page!
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Show time for one participant
extime(oTree, pcode = "wk247s9w")

# Make a data frame of durations
extime(oTree)

# Make a data frame of durations (beginning from the end of the second page)
extime(oTree, startat = 2)
}
\keyword{oTree}
