% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messy_time.R
\name{messy_time}
\alias{messy_time}
\title{Check if the Time data frame is messy}
\usage{
messy_time(
  oTree,
  combine = FALSE,
  epoch_time = TRUE,
  participant = TRUE,
  info = FALSE
)
}
\arguments{
\item{oTree}{A list of data frames that were created by import_otree().}

\item{combine}{Logical. TRUE if all variables referring to epoch time should
be merged and/or all variables referring to participant code should be merged
in case data of several versions of oTree are used.}

\item{epoch_time}{Logical. TRUE if all variables referring to the time stamp
should be checked and merged. Only works if combine = TRUE.}

\item{participant}{Logical. TRUE if all variables referring to the
participant code should be checked and merged. Only works if combine = TRUE.}

\item{info}{Logical. TRUE if a brief information on the process should
be printed.}
}
\value{
This function returns an oTree list of data frames that is
an exact copy of the original oTree list of data frames but - if the user
wishes to do so - combines the
time tamps and participant codes in the Time data frame if several variables
are referring to those because of the
combination of different oTree versions. The final variables are called
epoch_time_completed and participant_code.

If combine = FALSE, the function only checks for the existence of several
variables referring to the time stamp or the participant code and throws an
error if yes.
}
\description{
Check if the Time data frame includes both participant-related variables
and time stamp variables that appear multiple times. This may occur when
data from different oTree versions, which use different variable names,
are combined.

If desired, the function can merge these variables,
storing the data using the newer oTree version's variable names
and removing the outdated variables.
}
\examples{
\dontshow{if (rlang::is_installed("withr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set data folder first
withr::with_dir(system.file("extdata", package = "gmoTree"), {

# Import all oTree files in this folder and its subfolders
oTree <- import_otree()
})

# Show all Time column names
print(colnames(oTree$Time))

# Run function
oTree <- messy_time(oTree, combine = TRUE)

# Show all Time column names again
print(colnames(oTree$Time))
\dontshow{\}) # examplesIf}
}
\keyword{oTree}
