% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMVARconstruction.R
\name{swap_W_signs}
\alias{swap_W_signs}
\title{Swap all signs in pointed columns a the \eqn{W} matrix of a structural GMVAR model.}
\usage{
swap_W_signs(gmvar, which_to_swap)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{which_to_swap}{a numeric vector of length at most \eqn{d} and elemnts in \eqn{1,..,d}
specifying the columns of \eqn{W} whose sign should be swapped.}
}
\value{
Returns an object of class \code{'gmvar'} defining a structural GMVAR model with the modified
  structural parameters and constraints.
}
\description{
\code{swap_W_signs} swaps all signs in pointed columns a the \eqn{W} matrix
 of a structural GMVAR model. Consequently, signs in the columns of the B-matrix are also swapped
 accordingly.
}
\details{
All signs in any column of \eqn{W} can be swapped without changing the implied reduced form model.
  Consequently, also the signs in the columns of the B-matrix are swapped. Note that the sign constraints
  imposed on \eqn{W} (or the B-matrix) are also swapped in the corresponding columns accordingly.

  Also the order of the columns of \eqn{W} can be changed (without changing the implied reduced
  form model) as long as the order of lambda parameters is also changed accordingly. This can be
  done with the function \code{reorder_W_columns}.
}
\examples{
# Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
params222s <- c(-11.964, 155.024, 11.636, 124.988, 1.314, 0.145, 0.094, 1.292,
 -0.389, -0.07, -0.109, -0.281, 1.248, 0.077, -0.04, 1.266, -0.272, -0.074,
  0.034, -0.313, 0.903, 0.718, -0.324, 2.079, 7.00, 1.44, 0.742)
W_222 <- matrix(c(1, NA, -1, 1), nrow=2, byrow=FALSE)
mod222s <- GMVAR(p=2, M=2, d=2, params=params222s, parametrization="mean",
                 structural_pars=list(W=W_222))
mod222s

# The same reduced form model, with signs in the second column of W swapped:
swap_W_signs(mod222s, which_to_swap=2)

# The same reduced form model, with signs in both column of W swapped:
swap_W_signs(mod222s, which_to_swap=1:2)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{gmvar_to_sgmvar}}
}
